/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.ui.csrf;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.ui.csrf.CSRFToken;
import net.shibboleth.idp.ui.csrf.impl.SimpleCSRFToken;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import net.shibboleth.shared.security.RandomIdentifierParameterSpec;

@ThreadSafe
public final class CSRFTokenManager
extends AbstractInitializableComponent {
    @Nonnull
    private String csrfParameterName = "csrf_token";
    @NonnullAfterInit
    private IdentifierGenerationStrategy tokenGenerationStrategy;
    @Nonnull
    private BiPredicate<CSRFToken, String> csrfTokenValidationPredicate = new DefaultCSRFTokenValidationPredicate();

    public void setTokenGenerationStrategy(@Nonnull IdentifierGenerationStrategy tokenStrategy) {
        this.checkSetterPreconditions();
        this.tokenGenerationStrategy = (IdentifierGenerationStrategy)Constraint.isNotNull((Object)tokenStrategy, (String)"tokenGenerationStrategy cannot be null");
    }

    public void setCsrfTokenValidationPredicate(@Nonnull BiPredicate<CSRFToken, String> tokenValidationPredicate) {
        this.checkSetterPreconditions();
        this.csrfTokenValidationPredicate = (BiPredicate)Constraint.isNotNull(tokenValidationPredicate, (String)"CSRF token validation predicate can not be null");
    }

    public void setCsrfParameterName(@Nonnull @NotEmpty String parameterName) {
        this.checkSetterPreconditions();
        this.csrfParameterName = Constraint.isNotEmpty((String)parameterName, (String)"CsrfParameterName cannot be null or empty");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.tokenGenerationStrategy == null) {
            try {
                this.tokenGenerationStrategy = IdentifierGenerationStrategy.getInstance((IdentifierGenerationStrategy.ProviderType)IdentifierGenerationStrategy.ProviderType.SECURE, (IdentifierGenerationStrategy.ParameterSpec)new RandomIdentifierParameterSpec(null, Integer.valueOf(20), null));
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
                throw new ComponentInitializationException((Exception)e);
            }
        }
    }

    @Nonnull
    public CSRFToken generateCSRFToken() {
        this.checkComponentActive();
        return new SimpleCSRFToken(this.tokenGenerationStrategy.generateIdentifier(), this.csrfParameterName);
    }

    public boolean isValidCSRFToken(@Nullable CSRFToken csrfToken, @Nullable String requestCsrfToken) {
        this.checkComponentActive();
        return this.csrfTokenValidationPredicate.test(csrfToken, requestCsrfToken);
    }

    private static class DefaultCSRFTokenValidationPredicate
    implements BiPredicate<CSRFToken, String> {
        private DefaultCSRFTokenValidationPredicate() {
        }

        @Override
        public boolean test(@Nullable CSRFToken csrfToken, @Nullable String requestCSRFToken) {
            if (csrfToken == null || requestCSRFToken == null) {
                return false;
            }
            return csrfToken.getToken().equals(requestCSRFToken);
        }
    }
}

