/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.ui.taglib;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.tagext.BodyTagSupport;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.ui.context.RelyingPartyUIContext;
import net.shibboleth.shared.codec.HTMLEncoder;
import net.shibboleth.shared.primitive.DeprecationSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ServiceTagSupport
extends BodyTagSupport {
    private static final long serialVersionUID = 4405207268569727209L;
    @Nonnull
    private static Logger log = LoggerFactory.getLogger(ServiceTagSupport.class);
    @Nonnull
    private static Function<ProfileRequestContext, RelyingPartyUIContext> uiContextLookupStrategy = new ChildContextLookup(RelyingPartyUIContext.class).compose((Function)new ChildContextLookup(AuthenticationContext.class));
    @Nullable
    private String cssClass;
    @Nullable
    private String cssId;
    @Nullable
    private String cssStyle;
    @Nullable
    private RelyingPartyUIContext relyingPartyUIContext;

    public ServiceTagSupport() {
        String classname = ((Object)((Object)this)).getClass().getName();
        assert (classname != null);
        DeprecationSupport.atRiskOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CLASS, (String)classname, (String)"a jsp file");
    }

    @Deprecated
    public void setUiContext(@Nullable RelyingPartyUIContext value) {
        this.relyingPartyUIContext = value;
    }

    public void setCssClass(@Nullable String value) {
        this.cssClass = value;
    }

    public void setCssId(@Nullable String value) {
        this.cssId = value;
    }

    public void setCssStyle(@Nullable String value) {
        this.cssStyle = value;
    }

    protected void addClassAndId(@Nonnull StringBuilder sb) {
        if (this.cssClass != null) {
            sb.append(" class=\"").append(this.cssClass).append('\"');
        }
        if (this.cssId != null) {
            sb.append(" id=\"").append(this.cssId).append('\"');
        }
        if (this.cssStyle != null) {
            sb.append(" style=\"").append(this.cssStyle).append('\"');
        }
    }

    @Nonnull
    protected String buildHyperLink(@Nonnull String url, @Nullable String text) {
        String encodedUrl;
        try {
            URI theUrl = new URI(url);
            String scheme = theUrl.getScheme();
            if (!("http".equals(scheme) || "https".equals(scheme) || "mailto".equals(scheme))) {
                log.warn("The URL '{}' contained an invalid scheme.", (Object)url);
                return "";
            }
            encodedUrl = HTMLEncoder.encodeForHTMLAttribute((String)url);
        }
        catch (URISyntaxException e) {
            log.warn("The URL '{}' was invalid: ", (Object)url, (Object)e);
            return "";
        }
        StringBuilder sb = new StringBuilder("<a href=\"");
        sb.append(encodedUrl).append('\"');
        this.addClassAndId(sb);
        sb.append(">").append(HTMLEncoder.encodeForHTML((String)text)).append("</a>");
        String result = sb.toString();
        assert (result != null);
        return result;
    }

    @Nullable
    protected RelyingPartyUIContext getRelyingPartyUIContext() {
        if (null != this.relyingPartyUIContext) {
            return this.relyingPartyUIContext;
        }
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        if (request == null) {
            return null;
        }
        ProfileRequestContext pc = (ProfileRequestContext)request.getAttribute("profileRequestContext");
        return uiContextLookupStrategy.apply(pc);
    }

    @Nullable
    protected String getServiceName() {
        RelyingPartyUIContext ctx = this.getRelyingPartyUIContext();
        if (ctx == null) {
            return null;
        }
        return ctx.getServiceName();
    }
}

