/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.ui.csrf.impl;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import net.shibboleth.idp.ui.csrf.CSRFToken;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;

@Immutable
public class SimpleCSRFToken
implements CSRFToken {
    private static final long serialVersionUID = 3742188179558262003L;
    @Nonnull
    @NotEmpty
    private String token;
    @Nonnull
    @NotEmpty
    private String parameterName;

    public SimpleCSRFToken(@Nonnull @NotEmpty String csrfToken, @Nonnull @NotEmpty String paramName) {
        this.token = Constraint.isNotEmpty((String)csrfToken, (String)"CSRF Tokens can not be null or empty");
        this.parameterName = Constraint.isNotEmpty((String)paramName, (String)"CSRF parameter name can not be null or empty");
    }

    @Override
    @Nonnull
    public String getParameterName() {
        return this.parameterName;
    }

    @Override
    @Nonnull
    public String getToken() {
        return this.token;
    }
}

