/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.ui.helper;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public final class AttributeHelper
extends AbstractIdentifiableInitializableComponent {
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextStrategy = new ChildContextLookup(AttributeContext.class).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeHelper.class);

    public void setAttributeContextStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        this.attributeContextStrategy = (Function)Constraint.isNotNull(strategy, (String)"Injected strategy must not be null");
    }

    @Nullable
    public IdPAttributeValue getFirstAttributeValue(@Nonnull ProfileRequestContext prc, @Nonnull @NotEmpty String attributeName) {
        Constraint.isNotNull((Object)attributeName, (String)"Attribute Name must be non-null");
        AttributeContext context = this.attributeContextStrategy.apply(prc);
        if (context == null) {
            this.log.error("Attribute Context could not be located");
            return null;
        }
        return this.getFirstValue((IdPAttribute)context.getIdPAttributes().get(attributeName));
    }

    @Nonnull
    public String getFirstAttributeDisplayValue(@Nonnull ProfileRequestContext prc, @Nonnull @NotEmpty String attributeName, @Nonnull String defaultValue) {
        Constraint.isNotNull((Object)defaultValue, (String)"Default value must be non-null");
        IdPAttributeValue value = this.getFirstAttributeValue(prc, attributeName);
        if (value == null) {
            this.log.error("No Attribute Value found, returning {}", (Object)defaultValue);
            return defaultValue;
        }
        return value.getDisplayValue();
    }

    @Nonnull
    public String getFirstAttributeDisplayValue(@Nonnull ProfileRequestContext prc, @Nonnull @NotEmpty String attributeName) {
        return this.getFirstAttributeDisplayValue(prc, attributeName, "");
    }

    @Nullable
    public IdPAttributeValue getFirstUnfilteredAttributeValue(@Nonnull ProfileRequestContext prc, @Nonnull @NotEmpty String attributeName) {
        Constraint.isNotNull((Object)attributeName, (String)"Attribute Name must be non-null");
        AttributeContext context = this.attributeContextStrategy.apply(prc);
        if (context == null) {
            this.log.error("Attribute Context could not be located");
            return null;
        }
        return this.getFirstValue((IdPAttribute)context.getUnfilteredIdPAttributes().get(attributeName));
    }

    @Nonnull
    public String getFirstUnfilteredAttributeDisplayValue(@Nonnull ProfileRequestContext prc, @Nonnull @NotEmpty String attributeName, @Nonnull String defaultValue) {
        Constraint.isNotNull((Object)defaultValue, (String)"Default value must be non-null");
        IdPAttributeValue value = this.getFirstUnfilteredAttributeValue(prc, attributeName);
        if (value == null) {
            this.log.error("No Attribute Value found, returning {}", (Object)defaultValue);
            return defaultValue;
        }
        return value.getDisplayValue();
    }

    @Nonnull
    public String getFirstUnfilteredAttributeDisplayValue(@Nonnull ProfileRequestContext prc, @Nonnull @NotEmpty String attributeName) {
        return this.getFirstUnfilteredAttributeDisplayValue(prc, attributeName, "");
    }

    @Nullable
    private IdPAttributeValue getFirstValue(@Nullable IdPAttribute attribute) {
        if (attribute == null) {
            this.log.debug("No attribute found");
            return null;
        }
        List values = attribute.getValues();
        if (values == null || values.size() < 1) {
            this.log.info("No attribute values associated with {}", (Object)attribute.getId());
            return null;
        }
        return (IdPAttributeValue)values.get(0);
    }
}

