/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.ui.taglib;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.BodyContent;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.ui.context.RelyingPartyUIContext;
import net.shibboleth.idp.ui.taglib.ServiceTagSupport;
import net.shibboleth.shared.codec.HTMLEncoder;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class OrganizationDisplayNameTag
extends ServiceTagSupport {
    private static final long serialVersionUID = -196716418770324981L;
    @Nonnull
    private static Logger log = LoggerFactory.getLogger(OrganizationDisplayNameTag.class);

    @Nullable
    private String getOrganizationDisplayName() {
        RelyingPartyUIContext ctx = this.getRelyingPartyUIContext();
        if (ctx == null) {
            return null;
        }
        return ctx.getOrganizationDisplayName();
    }

    public int doEndTag() throws JspException {
        String name = this.getOrganizationDisplayName();
        try {
            if (null == name) {
                JspWriter ew;
                BodyContent bc = this.getBodyContent();
                if (null != bc && (ew = bc.getEnclosingWriter()) != null) {
                    bc.writeOut((Writer)ew);
                }
            } else {
                this.pageContext.getOut().print(HTMLEncoder.encodeForHTML((String)name));
            }
        }
        catch (IOException e) {
            log.warn("Error generating OrganizationDisplayName: {}", (Object)e.getMessage());
            throw new JspException("EndTag", (Throwable)e);
        }
        return super.doEndTag();
    }
}

