/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.ui.taglib;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.BodyContent;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.ui.context.RelyingPartyUIContext;
import net.shibboleth.idp.ui.taglib.ServiceTagSupport;
import net.shibboleth.shared.codec.HTMLEncoder;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class OrganizationNameTag
extends ServiceTagSupport {
    private static final long serialVersionUID = -6896271567378071224L;
    @Nonnull
    private static Logger log = LoggerFactory.getLogger(OrganizationNameTag.class);

    @Nullable
    private String getOrganizationName() {
        RelyingPartyUIContext ctx = this.getRelyingPartyUIContext();
        if (ctx == null) {
            return null;
        }
        return ctx.getOrganizationName();
    }

    public int doEndTag() throws JspException {
        String name = this.getOrganizationName();
        try {
            if (null == name) {
                JspWriter ew;
                BodyContent bc = this.getBodyContent();
                if (null != bc && (ew = bc.getEnclosingWriter()) != null) {
                    bc.writeOut((Writer)ew);
                }
            } else {
                this.pageContext.getOut().print(HTMLEncoder.encodeForHTML((String)name));
            }
        }
        catch (IOException e) {
            log.warn("Error generating OrganizationName: {}", (Object)e.getMessage());
            throw new JspException("EndTag", (Throwable)e);
        }
        return super.doEndTag();
    }
}

