/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.ui.taglib;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.BodyContent;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.ui.context.RelyingPartyUIContext;
import net.shibboleth.idp.ui.taglib.ServiceTagSupport;
import net.shibboleth.shared.codec.HTMLEncoder;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.ContactPersonTypeEnumeration;
import org.opensaml.saml.saml2.metadata.EmailAddress;
import org.opensaml.saml.saml2.metadata.GivenName;
import org.opensaml.saml.saml2.metadata.SurName;
import org.slf4j.Logger;

public class ServiceContactTag
extends ServiceTagSupport {
    private static final long serialVersionUID = 5437171915434315671L;
    @Nonnull
    private static Logger log = LoggerFactory.getLogger(ServiceContactTag.class);
    @Nonnull
    private ContactPersonTypeEnumeration contactType = ContactPersonTypeEnumeration.SUPPORT;
    @Nullable
    private String contactName;

    public void setContactType(@Nullable String type) {
        if (null == type || 0 == type.length()) {
            log.warn("no parameter provided to contactType");
            return;
        }
        if (type.equals(ContactPersonTypeEnumeration.ADMINISTRATIVE.toString())) {
            this.contactType = ContactPersonTypeEnumeration.ADMINISTRATIVE;
        } else if (type.equals(ContactPersonTypeEnumeration.BILLING.toString())) {
            this.contactType = ContactPersonTypeEnumeration.BILLING;
        } else if (type.equals(ContactPersonTypeEnumeration.OTHER.toString())) {
            this.contactType = ContactPersonTypeEnumeration.OTHER;
        } else if (type.equals(ContactPersonTypeEnumeration.SUPPORT.toString())) {
            this.contactType = ContactPersonTypeEnumeration.SUPPORT;
        } else if (type.equals(ContactPersonTypeEnumeration.TECHNICAL.toString())) {
            this.contactType = ContactPersonTypeEnumeration.TECHNICAL;
        } else {
            log.warn("parameter provided to contactType:" + type + " is invalid");
        }
    }

    public void setName(@Nullable String name) {
        this.contactName = name;
    }

    @Nullable
    private String buildURL(@Nullable String email, @Nullable String name) {
        if (null != email) {
            log.debug("constructing hyperlink from name '{}' and email '{}'", (Object)name, (Object)email);
            return this.buildHyperLink(email, name);
        }
        log.debug("no email found, using name '{}' with no hyperlink", (Object)name);
        if (null != name) {
            return HTMLEncoder.encodeForHTML((String)name);
        }
        return null;
    }

    @Nullable
    private String getStringFromContact(ContactPerson contact) {
        List emails = contact.getEmailAddresses();
        String emailAddress = null;
        if (!emails.isEmpty()) {
            emailAddress = ((EmailAddress)emails.get(0)).getURI();
        }
        if (null != this.contactName) {
            return this.buildURL(emailAddress, this.contactName);
        }
        SurName surName = contact.getSurName();
        GivenName givenName = contact.getGivenName();
        StringBuilder fullName = new StringBuilder();
        if (null != givenName) {
            fullName.append(givenName.getValue()).append(" ");
        }
        if (null != surName) {
            fullName.append(surName.getValue()).append(" ");
        }
        if (0 == fullName.length()) {
            log.debug("no names found, using email address as text");
            fullName.append(emailAddress);
        }
        return this.buildURL(emailAddress, fullName.toString());
    }

    @Nullable
    protected String getContactFromEntity() {
        RelyingPartyUIContext ctx = this.getRelyingPartyUIContext();
        if (ctx == null) {
            return null;
        }
        ContactPerson contact = ctx.getContactPerson(this.contactType);
        if (null == contact) {
            return null;
        }
        return this.getStringFromContact(contact);
    }

    public int doEndTag() throws JspException {
        String result = this.getContactFromEntity();
        try {
            if (null == result) {
                JspWriter ew;
                BodyContent bc = this.getBodyContent();
                if (null != bc && (ew = bc.getEnclosingWriter()) != null) {
                    bc.writeOut((Writer)ew);
                }
            } else {
                this.pageContext.getOut().print(result);
            }
        }
        catch (IOException e) {
            log.warn("Error generating contact: {}", (Object)e.getMessage());
            throw new JspException("EndTag", (Throwable)e);
        }
        return super.doEndTag();
    }
}

