/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.ui.taglib;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.BodyContent;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.ui.context.RelyingPartyUIContext;
import net.shibboleth.idp.ui.taglib.ServiceTagSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class ServicePrivacyURLTag
extends ServiceTagSupport {
    private static final long serialVersionUID = -5857694815588394787L;
    @Nonnull
    private static Logger log = LoggerFactory.getLogger(ServicePrivacyURLTag.class);
    @Nullable
    private static String linkText;

    public void setLinkText(@Nullable String text) {
        linkText = text;
    }

    @Nullable
    private String getPrivacyURLFromUIIinfo() {
        RelyingPartyUIContext ctx = this.getRelyingPartyUIContext();
        if (ctx == null) {
            return null;
        }
        return ctx.getPrivacyStatementURL();
    }

    public int doEndTag() throws JspException {
        String privacyURL = this.getPrivacyURLFromUIIinfo();
        try {
            if (null == privacyURL) {
                JspWriter ew;
                BodyContent bc = this.getBodyContent();
                if (null != bc && (ew = bc.getEnclosingWriter()) != null) {
                    bc.writeOut((Writer)ew);
                }
            } else {
                this.pageContext.getOut().print(this.buildHyperLink(privacyURL, linkText));
            }
        }
        catch (IOException e) {
            log.warn("Error generating PrivacyStatementURL: {}", (Object)e.getMessage());
            throw new JspException("EndTag", (Throwable)e);
        }
        return super.doEndTag();
    }
}

