/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.impl;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import net.shibboleth.idp.attribute.DurablePairwiseIdStore;
import net.shibboleth.idp.attribute.PairwiseId;
import net.shibboleth.idp.attribute.PairwiseIdStore;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NonNegative;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

public class JDBCPairwiseIdStore
extends AbstractInitializableComponent
implements DurablePairwiseIdStore {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(JDBCPairwiseIdStore.class);
    @NonnullAfterInit
    private DataSource dataSource;
    @Nonnull
    private Duration queryTimeout;
    @NonNegative
    private int transactionRetry = 3;
    private int transactionIsolation = 8;
    @Nonnull
    private Collection<String> retryableErrors = CollectionSupport.listOf((Object)"23000", (Object)"23505");
    private ReadWriteLock readWriteLock;
    private boolean verifyDatabase;
    @Nonnull
    @NotEmpty
    private String tableName;
    @Nonnull
    @NotEmpty
    private String issuerColumn;
    @Nonnull
    @NotEmpty
    private String recipientColumn;
    @Nonnull
    @NotEmpty
    private String principalNameColumn;
    @Nonnull
    @NotEmpty
    private String sourceIdColumn;
    @Nonnull
    @NotEmpty
    private String persistentIdColumn;
    @Nonnull
    @NotEmpty
    private String peerProvidedIdColumn;
    @Nonnull
    @NotEmpty
    private String creationTimeColumn;
    @Nonnull
    @NotEmpty
    private String deactivationTimeColumn;
    @NonnullAfterInit
    private String getByIssuedSelectSQL;
    @NonnullAfterInit
    private String getBySourceSelectSQL;
    @NonnullAfterInit
    private String insertSQL;
    @NonnullAfterInit
    private String deactivateSQL;
    @NonnullAfterInit
    private String attachSQL;
    @NonnullAfterInit
    private String deleteSQL;
    @Nullable
    private PairwiseIdStore initialValueStore;

    public JDBCPairwiseIdStore() {
        Duration fiveSecs = Duration.ofSeconds(5L);
        assert (fiveSecs != null);
        this.queryTimeout = fiveSecs;
        this.verifyDatabase = true;
        this.tableName = "shibpid";
        this.issuerColumn = "localEntity";
        this.recipientColumn = "peerEntity";
        this.principalNameColumn = "principalName";
        this.sourceIdColumn = "localId";
        this.persistentIdColumn = "persistentId";
        this.peerProvidedIdColumn = "peerProvidedId";
        this.creationTimeColumn = "creationDate";
        this.deactivationTimeColumn = "deactivationDate";
    }

    @NonnullAfterInit
    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(@Nonnull DataSource source) {
        this.checkSetterPreconditions();
        this.dataSource = (DataSource)Constraint.isNotNull((Object)source, (String)"DataSource cannot be null");
    }

    public void setLocalLocking(boolean what) {
        this.checkSetterPreconditions();
        this.readWriteLock = what ? new ReentrantReadWriteLock(true) : null;
    }

    public boolean isLocalLocking() {
        return this.readWriteLock != null;
    }

    public void setTransactionIsolation(int what) {
        Constraint.isTrue((what == 2 || what == 1 || what == 4 || what == 8 ? 1 : 0) != 0, (String)"Invalid value for TransactionIsolation");
        this.transactionIsolation = what;
    }

    @Nonnull
    public Duration getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(@Nonnull Duration timeout) {
        this.checkSetterPreconditions();
        Constraint.isNotNull((Object)timeout, (String)"Timeout cannot be null");
        Constraint.isFalse((boolean)timeout.isNegative(), (String)"Timeout cannot be negative");
        this.queryTimeout = timeout;
    }

    public int getTransactionRetries() {
        return this.transactionRetry;
    }

    public void setTransactionRetries(@NonNegative int retries) {
        this.checkSetterPreconditions();
        this.transactionRetry = Constraint.isGreaterThanOrEqual((int)0, (int)retries, (String)"Retries must be greater than or equal to 0");
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Collection<String> getRetryableErrors() {
        return this.retryableErrors;
    }

    public void setRetryableErrors(@Nullable Collection<String> errors) {
        this.checkSetterPreconditions();
        this.retryableErrors = CollectionSupport.copyToList((Collection)StringSupport.normalizeStringCollection(errors));
    }

    public boolean getVerifyDatabase() {
        return this.verifyDatabase;
    }

    public void setVerifyDatabase(boolean flag) {
        this.checkSetterPreconditions();
        this.verifyDatabase = flag;
    }

    @Nonnull
    @NotEmpty
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(@Nonnull @NotEmpty String name) {
        this.checkSetterPreconditions();
        this.tableName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Table name cannot be null or empty");
    }

    public void setLocalEntityColumn(@Nonnull @NotEmpty String name) {
        this.checkSetterPreconditions();
        this.issuerColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    public void setPeerEntityColumn(@Nonnull @NotEmpty String name) {
        this.checkSetterPreconditions();
        this.recipientColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    public void setPrincipalNameColumn(@Nonnull @NotEmpty String name) {
        this.checkSetterPreconditions();
        this.principalNameColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    public void setSourceIdColumn(@Nonnull @NotEmpty String name) {
        this.checkSetterPreconditions();
        this.sourceIdColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    public void setPersistentIdColumn(@Nonnull @NotEmpty String name) {
        this.checkSetterPreconditions();
        this.persistentIdColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    public void setPeerProvidedIdColumn(@Nonnull @NotEmpty String name) {
        this.checkSetterPreconditions();
        this.peerProvidedIdColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    public void setCreateTimeColumn(@Nonnull @NotEmpty String name) {
        this.checkSetterPreconditions();
        this.creationTimeColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    public void setDeactivationTimeColumn(@Nonnull @NotEmpty String name) {
        this.checkSetterPreconditions();
        this.deactivationTimeColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    public void setGetByIssuedSelectSQL(@Nonnull @NotEmpty String sql) {
        this.checkSetterPreconditions();
        this.getByIssuedSelectSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)sql), (String)"SQL statement cannot be null or empty");
    }

    public void setGetBySourceSelectSQL(@Nonnull @NotEmpty String sql) {
        this.checkSetterPreconditions();
        this.getBySourceSelectSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)sql), (String)"SQL statement cannot be null or empty");
    }

    public void setInsertSQL(@Nonnull @NotEmpty String sql) {
        this.checkSetterPreconditions();
        this.insertSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)sql), (String)"SQL statement cannot be null or empty");
    }

    public void setDeactivateSQL(@Nonnull @NotEmpty String sql) {
        this.checkSetterPreconditions();
        this.deactivateSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)sql), (String)"SQL statement cannot be null or empty");
    }

    public void setAttachSQL(@Nonnull @NotEmpty String sql) {
        this.checkSetterPreconditions();
        this.attachSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)sql), (String)"SQL statement cannot be null or empty");
    }

    public void setDeleteSQL(@Nonnull @NotEmpty String sql) {
        this.checkSetterPreconditions();
        this.deleteSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)sql), (String)"SQL statement cannot be null or empty");
    }

    @Nullable
    public PairwiseIdStore getInitialValueStore() {
        return this.initialValueStore;
    }

    public void setInitialValueStore(@Nullable PairwiseIdStore store) {
        this.checkSetterPreconditions();
        this.initialValueStore = store;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.dataSource) {
            throw new ComponentInitializationException("DataSource cannot be null");
        }
        if (this.getByIssuedSelectSQL == null) {
            this.getByIssuedSelectSQL = "SELECT * FROM " + this.tableName + " WHERE " + this.issuerColumn + "= ? AND " + this.recipientColumn + "= ? AND " + this.persistentIdColumn + "= ?";
        }
        if (this.getBySourceSelectSQL == null) {
            this.getBySourceSelectSQL = "SELECT * FROM " + this.tableName + " WHERE " + this.issuerColumn + "= ? AND " + this.recipientColumn + "= ? AND " + this.sourceIdColumn + "= ? AND (" + this.deactivationTimeColumn + " IS NULL OR " + this.deactivationTimeColumn + " = (SELECT MAX(" + this.deactivationTimeColumn + ") FROM " + this.tableName + " WHERE " + this.issuerColumn + "= ? AND " + this.recipientColumn + "= ? AND " + this.sourceIdColumn + "= ?)) ORDER BY " + this.creationTimeColumn + " DESC";
        }
        if (this.insertSQL == null) {
            this.insertSQL = "INSERT INTO " + this.tableName + " (" + this.issuerColumn + ", " + this.recipientColumn + ", " + this.persistentIdColumn + ", " + this.principalNameColumn + ", " + this.sourceIdColumn + ", " + this.peerProvidedIdColumn + ", " + this.creationTimeColumn + ", " + this.deactivationTimeColumn + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        }
        if (this.deactivateSQL == null) {
            this.deactivateSQL = "UPDATE " + this.tableName + " SET " + this.deactivationTimeColumn + "= ? WHERE " + this.issuerColumn + "= ? AND " + this.recipientColumn + "= ? AND " + this.persistentIdColumn + "= ?";
        }
        if (this.attachSQL == null) {
            this.attachSQL = "UPDATE " + this.tableName + " SET " + this.peerProvidedIdColumn + "= ? WHERE " + this.issuerColumn + "= ? AND " + this.recipientColumn + "= ? AND " + this.persistentIdColumn + "= ?";
        }
        if (this.deleteSQL == null) {
            this.deleteSQL = "DELETE FROM " + this.tableName + " WHERE " + this.issuerColumn + "= ?";
        }
        try {
            this.verifyDatabase();
            this.log.info("DataSource successfully verified");
        }
        catch (SQLException e) {
            if (this.verifyDatabase) {
                this.log.error("Exception verifying database", (Throwable)e);
                throw new ComponentInitializationException("The database was not reachable or was not defined with an appropriate table + primary key");
            }
            this.log.warn("The database was not reachable or was not defined with an appropriate table + primary key", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public PairwiseId getBySourceValue(@Nonnull PairwiseId pid, boolean allowCreate) throws IOException {
        this.checkComponentActive();
        Constraint.isNotNull((Object)pid, (String)"Input PairwiseId object cannot be null");
        Constraint.isNotEmpty((String)pid.getIssuerEntityID(), (String)"Issuer entityID cannot be null or empty");
        Constraint.isNotEmpty((String)pid.getRecipientEntityID(), (String)"Recipient entityID cannot be null or empty");
        Constraint.isNotEmpty((String)pid.getPrincipalName(), (String)"Principal name cannot be null or empty");
        Constraint.isNotEmpty((String)pid.getSourceSystemId(), (String)"Source system ID cannot be null or empty");
        this.log.debug("Obtaining pairwise ID for source ID: {}", (Object)pid.getSourceSystemId());
        this.log.trace("Prepared statement: {}", (Object)this.getBySourceSelectSQL);
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)1, (Object)pid.getIssuerEntityID());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)2, (Object)pid.getRecipientEntityID());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)3, (Object)pid.getSourceSystemId());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)4, (Object)pid.getIssuerEntityID());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)5, (Object)pid.getRecipientEntityID());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)6, (Object)pid.getSourceSystemId());
        int retries = this.transactionRetry;
        while (true) {
            try (ConnectionWithLock dbConn = new ConnectionWithLock(false, false);){
                Instant deactivationTime;
                PreparedStatement statement = dbConn.prepareStatement(this.getBySourceSelectSQL);
                statement.setString(1, pid.getIssuerEntityID());
                statement.setString(2, pid.getRecipientEntityID());
                statement.setString(3, pid.getSourceSystemId());
                statement.setString(4, pid.getIssuerEntityID());
                statement.setString(5, pid.getRecipientEntityID());
                statement.setString(6, pid.getSourceSystemId());
                this.log.debug("Getting active and/or last inactive pairwise ID entry");
                ResultSet resultSet = statement.executeQuery();
                assert (resultSet != null);
                List<PairwiseId> entries = this.buildIdentifierEntries(resultSet);
                if (entries != null && entries.size() > 0 && ((deactivationTime = entries.get(0).getDeactivationTime()) == null || deactivationTime.isAfter(Instant.now()))) {
                    dbConn.commit();
                    this.log.debug("Returning existing active pairwise ID: {}", (Object)entries.get(0).getPairwiseId());
                    PairwiseId pairwiseId = entries.get(0);
                    return pairwiseId;
                }
                if (!allowCreate) {
                    dbConn.commit();
                    this.log.debug("No existing pairwise ID and creation is not permitted by caller");
                    PairwiseId pairwiseId = null;
                    return pairwiseId;
                }
                pid.setCreationTime(Instant.now());
                PairwiseId retValue = pid;
                if ((entries == null || entries.size() == 0) && this.initialValueStore != null) {
                    this.log.debug("Issuing new pairwise ID using initial value store");
                    assert (this.initialValueStore != null);
                    retValue = this.initialValueStore.getBySourceValue(pid, allowCreate);
                    if (retValue == null) {
                        throw new IOException("Unable to obtain value from initial value store");
                    }
                } else {
                    this.log.debug("Issuing new random pairwise ID");
                    retValue.setPairwiseId(UUID.randomUUID().toString());
                    if (entries != null && entries.size() > 0) {
                        retValue.setPeerProvidedId(entries.get(0).getPeerProvidedId());
                    }
                }
                this.store(retValue, dbConn);
                dbConn.commit();
                PairwiseId pairwiseId = retValue;
                return pairwiseId;
            }
            catch (SQLException e) {
                boolean retry = false;
                for (String msg : this.retryableErrors) {
                    if (e.getSQLState() == null || !e.getSQLState().contains(msg)) continue;
                    this.log.warn("Caught retryable SQL exception", (Throwable)e);
                    retry = true;
                    break;
                }
                if (!retry) throw new IOException(e);
                if (--retries < 0) {
                    this.log.warn("Error retryable, but retry limit exceeded");
                    throw new IOException(e);
                }
                this.log.info("Retrying pairwise ID lookup/create operation");
                continue;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public PairwiseId getByIssuedValue(@Nonnull PairwiseId pid) throws IOException {
        this.checkComponentActive();
        Constraint.isNotNull((Object)pid, (String)"Input PairwiseId object cannot be null");
        Constraint.isNotEmpty((String)pid.getIssuerEntityID(), (String)"Issuer entityID cannot be null or empty");
        Constraint.isNotEmpty((String)pid.getRecipientEntityID(), (String)"Recipient entityID cannot be null or empty");
        Constraint.isNotEmpty((String)pid.getPairwiseId(), (String)"Pairwise ID cannot be null or empty");
        this.log.debug("Selecting previously issued pairwise ID entry", (Object)this.getByIssuedSelectSQL);
        this.log.trace("Prepared statement: {}", (Object)this.getByIssuedSelectSQL);
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)1, (Object)pid.getIssuerEntityID());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)2, (Object)pid.getRecipientEntityID());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)3, (Object)pid.getPairwiseId());
        try (ConnectionWithLock dbConn = new ConnectionWithLock(true, false);){
            Instant deactivationTime;
            PreparedStatement statement = dbConn.prepareStatement(this.getByIssuedSelectSQL);
            statement.setString(1, pid.getIssuerEntityID());
            statement.setString(2, pid.getRecipientEntityID());
            statement.setString(3, pid.getPairwiseId());
            ResultSet resultSet = statement.executeQuery();
            assert (resultSet != null);
            List<PairwiseId> entries = this.buildIdentifierEntries(resultSet);
            if (entries == null || entries.size() == 0) {
                PairwiseId pairwiseId = null;
                return pairwiseId;
            }
            if (entries.size() > 1) {
                this.log.error("More than one record found for a single persistent ID value");
            }
            if ((deactivationTime = entries.get(0).getDeactivationTime()) != null && !deactivationTime.isAfter(Instant.now())) {
                PairwiseId pairwiseId = null;
                return pairwiseId;
            }
            PairwiseId pairwiseId = entries.get(0);
            return pairwiseId;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public void deactivate(@Nonnull PairwiseId pid) throws IOException {
        this.checkComponentActive();
        Constraint.isNotNull((Object)pid, (String)"Input PairwiseId object cannot be null");
        Constraint.isNotEmpty((String)pid.getIssuerEntityID(), (String)"Issuer entityID cannot be null or empty");
        Constraint.isNotEmpty((String)pid.getRecipientEntityID(), (String)"Recipient entityID cannot be null or empty");
        Constraint.isNotEmpty((String)pid.getPairwiseId(), (String)"Pairwise ID cannot be null or empty");
        Instant deactivationTimeFromPID = pid.getDeactivationTime();
        Timestamp deactivationTime = deactivationTimeFromPID == null ? new Timestamp(System.currentTimeMillis()) : new Timestamp(deactivationTimeFromPID.toEpochMilli());
        this.log.debug("Deactivating pairwise ID {} as of {}", (Object)pid.getPairwiseId(), (Object)deactivationTime);
        this.log.trace("Prepared statement: {}", (Object)this.deactivateSQL);
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)1, (Object)deactivationTime);
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)2, (Object)pid.getIssuerEntityID());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)3, (Object)pid.getRecipientEntityID());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)4, (Object)pid.getPairwiseId());
        try (ConnectionWithLock dbConn = new ConnectionWithLock(true, true);){
            PreparedStatement statement = dbConn.prepareStatement(this.deactivateSQL);
            statement.setTimestamp(1, deactivationTime);
            statement.setString(2, pid.getIssuerEntityID());
            statement.setString(3, pid.getRecipientEntityID());
            statement.setString(4, pid.getPairwiseId());
            int rowCount = statement.executeUpdate();
            if (rowCount != 1) {
                this.log.warn("Unexpected result, statement affected {} rows", (Object)rowCount);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public void attach(@Nonnull PairwiseId pid) throws IOException {
        this.checkComponentActive();
        Constraint.isNotNull((Object)pid, (String)"Input PairwiseId object cannot be null");
        Constraint.isNotEmpty((String)pid.getIssuerEntityID(), (String)"Issuer entityID cannot be null or empty");
        Constraint.isNotEmpty((String)pid.getRecipientEntityID(), (String)"Recipient entityID cannot be null or empty");
        Constraint.isNotEmpty((String)pid.getPairwiseId(), (String)"Pairwise ID cannot be null or empty");
        Constraint.isNotEmpty((String)pid.getPeerProvidedId(), (String)"Peer-provided ID cannot be null or empty");
        this.log.debug("Attaching peer-provided ID {} to pairwise id {}", (Object)pid.getPeerProvidedId(), (Object)pid.getPairwiseId());
        this.log.trace("Prepared statement: {}", (Object)this.attachSQL);
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)1, (Object)pid.getPeerProvidedId());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)2, (Object)pid.getIssuerEntityID());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)3, (Object)pid.getRecipientEntityID());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)4, (Object)pid.getPairwiseId());
        try (ConnectionWithLock dbConn = new ConnectionWithLock(true, true);){
            PreparedStatement statement = dbConn.prepareStatement(this.attachSQL);
            statement.setString(1, pid.getPeerProvidedId());
            statement.setString(2, pid.getIssuerEntityID());
            statement.setString(3, pid.getRecipientEntityID());
            statement.setString(4, pid.getPairwiseId());
            int rowCount = statement.executeUpdate();
            if (rowCount != 1) {
                this.log.warn("Unexpected result, statement affected {} rows", (Object)rowCount);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    void store(@Nonnull PairwiseId entry, @Nonnull ConnectionWithLock dbConn) throws SQLException {
        this.log.debug("Storing new pairwise ID entry");
        if (StringSupport.trimOrNull((String)entry.getIssuerEntityID()) == null || StringSupport.trimOrNull((String)entry.getRecipientEntityID()) == null || StringSupport.trimOrNull((String)entry.getPairwiseId()) == null || StringSupport.trimOrNull((String)entry.getPrincipalName()) == null || StringSupport.trimOrNull((String)entry.getSourceSystemId()) == null || entry.getCreationTime() == null) {
            throw new SQLException("Required field was empty/null, store operation not possible");
        }
        this.log.trace("Prepared statement: {}", (Object)this.insertSQL);
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)1, (Object)entry.getIssuerEntityID());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)2, (Object)entry.getRecipientEntityID());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)3, (Object)entry.getPairwiseId());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)4, (Object)entry.getPrincipalName());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)5, (Object)entry.getSourceSystemId());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)6, (Object)entry.getPeerProvidedId());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)7, (Object)entry.getCreationTime());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)8, (Object)entry.getDeactivationTime());
        PreparedStatement statement = dbConn.prepareStatement(this.insertSQL);
        statement.setString(1, entry.getIssuerEntityID());
        statement.setString(2, entry.getRecipientEntityID());
        statement.setString(3, entry.getPairwiseId());
        statement.setString(4, entry.getPrincipalName());
        statement.setString(5, entry.getSourceSystemId());
        if (entry.getPeerProvidedId() != null) {
            statement.setString(6, entry.getPeerProvidedId());
        } else {
            statement.setNull(6, 12);
        }
        Instant creationTime = entry.getCreationTime();
        if (creationTime != null) {
            statement.setTimestamp(7, new Timestamp(creationTime.toEpochMilli()));
        } else {
            statement.setNull(7, 93);
        }
        Instant deactivationTime = entry.getDeactivationTime();
        if (deactivationTime != null) {
            statement.setTimestamp(8, new Timestamp(deactivationTime.toEpochMilli()));
        } else {
            statement.setNull(8, 93);
        }
        statement.executeUpdate();
    }

    private void verifyDatabase() throws SQLException {
        ConnectionWithLock conn;
        boolean keyMissing;
        String uuid;
        block19: {
            uuid = UUID.randomUUID().toString();
            PairwiseId newEntry = new PairwiseId();
            newEntry.setIssuerEntityID("http://dummy.com/idp/" + uuid);
            newEntry.setRecipientEntityID("http://dummy.com/sp/" + uuid);
            newEntry.setSourceSystemId("dummy");
            newEntry.setPrincipalName("dummy");
            newEntry.setCreationTime(Instant.now());
            newEntry.setPairwiseId(uuid);
            try (ConnectionWithLock conn2 = new ConnectionWithLock(true, true);){
                this.store(newEntry, conn2);
            }
            keyMissing = false;
            try {
                conn = new ConnectionWithLock(true, true);
                try {
                    this.store(newEntry, conn);
                    keyMissing = true;
                }
                finally {
                    conn.close();
                }
            }
            catch (SQLException e) {
                if (e.getSQLState() == null || this.retryableErrors.contains(e.getSQLState())) break block19;
                this.log.warn("Duplicate insert failed as required with SQL State '{}', ensure this value is configured as a retryable error", (Object)e.getSQLState());
            }
        }
        conn = new ConnectionWithLock(true, true);
        try {
            PreparedStatement statement = conn.prepareStatement(this.deleteSQL);
            statement.setString(1, "http://dummy.com/idp/" + uuid);
            statement.executeUpdate();
        }
        finally {
            conn.close();
        }
        if (keyMissing) {
            throw new SQLException("Duplicate insertion succeeded, primary key missing from table");
        }
    }

    @Nonnull
    @Live
    private List<PairwiseId> buildIdentifierEntries(@Nonnull ResultSet resultSet) throws SQLException {
        ArrayList<PairwiseId> entries = new ArrayList<PairwiseId>();
        while (resultSet.next()) {
            PairwiseId entry = new PairwiseId();
            entry.setIssuerEntityID(resultSet.getString(this.issuerColumn));
            entry.setRecipientEntityID(resultSet.getString(this.recipientColumn));
            entry.setPrincipalName(resultSet.getString(this.principalNameColumn));
            entry.setPairwiseId(resultSet.getString(this.persistentIdColumn));
            entry.setSourceSystemId(resultSet.getString(this.sourceIdColumn));
            entry.setPeerProvidedId(resultSet.getString(this.peerProvidedIdColumn));
            Timestamp ts = resultSet.getTimestamp(this.creationTimeColumn);
            if (ts != null) {
                entry.setCreationTime(Instant.ofEpochMilli(ts.getTime()));
            }
            if ((ts = resultSet.getTimestamp(this.deactivationTimeColumn)) != null) {
                entry.setDeactivationTime(Instant.ofEpochMilli(ts.getTime()));
            }
            entries.add(entry);
            this.log.trace("Entry {} added to results", (Object)entry.toString());
        }
        return entries;
    }

    protected class ConnectionWithLock
    implements AutoCloseable {
        @Nonnull
        private final Connection connection;
        @Nullable
        private final Lock threadLock;

        public ConnectionWithLock(boolean autoCommit, boolean writeLock) throws SQLException {
            Connection conn = JDBCPairwiseIdStore.this.dataSource.getConnection();
            assert (conn != null);
            this.connection = conn;
            this.connection.setAutoCommit(autoCommit);
            this.connection.setTransactionIsolation(JDBCPairwiseIdStore.this.transactionIsolation);
            if (JDBCPairwiseIdStore.this.readWriteLock != null) {
                Lock tlock = writeLock ? JDBCPairwiseIdStore.this.readWriteLock.writeLock() : JDBCPairwiseIdStore.this.readWriteLock.readLock();
                if (tlock != null) {
                    this.threadLock = tlock;
                    this.threadLock.lock();
                } else {
                    JDBCPairwiseIdStore.this.log.error("Unable to get local lock");
                    this.threadLock = null;
                }
            } else {
                this.threadLock = null;
            }
        }

        @Nonnull
        public PreparedStatement prepareStatement(String sql) throws SQLException {
            PreparedStatement statement = this.connection.prepareStatement(sql);
            statement.setQueryTimeout((int)JDBCPairwiseIdStore.this.queryTimeout.toSeconds());
            return statement;
        }

        public void commit() throws SQLException {
            this.connection.commit();
        }

        @Override
        public void close() {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                JDBCPairwiseIdStore.this.log.error("Auto close failed", (Throwable)e);
            }
            if (this.threadLock != null) {
                this.threadLock.unlock();
            }
        }
    }
}

