/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.idp.attribute.resolver.spring.impl;

import javax.annotation.Nonnull;

import org.springframework.beans.factory.xml.BeanDefinitionParser;

import net.shibboleth.idp.attribute.resolver.spring.ad.impl.ContextDerivedAttributeDefinitionParser;
import net.shibboleth.idp.attribute.resolver.spring.ad.impl.DateTimeAttributeDefinitionParser;
import net.shibboleth.idp.attribute.resolver.spring.ad.impl.PrescopedAttributeDefinitionParser;
import net.shibboleth.idp.attribute.resolver.spring.ad.impl.PrincipalNameAttributeDefinitionParser;
import net.shibboleth.idp.attribute.resolver.spring.ad.impl.RegexSplitAttributeDefinitionParser;
import net.shibboleth.idp.attribute.resolver.spring.ad.impl.SAML1NameIdentifierAttributeDefinitionParser;
import net.shibboleth.idp.attribute.resolver.spring.ad.impl.SAML2NameIDAttributeDefinitionParser;
import net.shibboleth.idp.attribute.resolver.spring.ad.impl.ScopedAttributeDefinitionParser;
import net.shibboleth.idp.attribute.resolver.spring.ad.impl.ScriptedAttributeDefinitionParser;
import net.shibboleth.idp.attribute.resolver.spring.ad.impl.SimpleAttributeDefinitionParser;
import net.shibboleth.idp.attribute.resolver.spring.ad.impl.DecryptedAttributeDefinitionParser;
import net.shibboleth.idp.attribute.resolver.spring.ad.impl.SubjectDerivedAttributeDefinitionParser;
import net.shibboleth.idp.attribute.resolver.spring.ad.impl.TemplateAttributeDefinitionParser;
import net.shibboleth.idp.attribute.resolver.spring.ad.mapped.impl.MappedAttributeDefinitionParser;
import net.shibboleth.idp.attribute.resolver.spring.ad.mapped.impl.SourceValueParser;
import net.shibboleth.idp.attribute.resolver.spring.ad.mapped.impl.ValueMapParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.http.impl.HTTPDataConnectorParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.ComputedIdDataConnectorParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.EntityAttributesDataConnectorParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.PairwiseIdDataConnectorParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.ScriptedDataConnectorParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.StaticDataConnectorParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.StoredIdDataConnectorParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.SubjectDataConnectorParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.ldap.impl.LDAPDataConnectorParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.rdbms.impl.RDBMSDataConnectorParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.storage.impl.StorageServiceDataConnectorParser;
import net.shibboleth.idp.attribute.resolver.spring.enc.impl.SAML1Base64AttributeEncoderParser;
import net.shibboleth.idp.attribute.resolver.spring.enc.impl.SAML1ScopedStringAttributeEncoderParser;
import net.shibboleth.idp.attribute.resolver.spring.enc.impl.SAML1StringAttributeEncoderParser;
import net.shibboleth.idp.attribute.resolver.spring.enc.impl.SAML1XMLObjectAttributeEncoderParser;
import net.shibboleth.idp.attribute.resolver.spring.enc.impl.SAML2Base64AttributeEncoderParser;
import net.shibboleth.idp.attribute.resolver.spring.enc.impl.SAML2DateTimeAttributeEncoderParser;
import net.shibboleth.idp.attribute.resolver.spring.enc.impl.SAML2ScopedStringAttributeEncoderParser;
import net.shibboleth.idp.attribute.resolver.spring.enc.impl.SAML2StringAttributeEncoderParser;
import net.shibboleth.idp.attribute.resolver.spring.enc.impl.SAML2XMLObjectAttributeEncoderParser;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.spring.custom.BaseSpringNamespaceHandler;

/** Namespace handler for the attribute resolver. */
public class AttributeResolverNamespaceHandler extends BaseSpringNamespaceHandler {

    /** Namespace for this handler. */
    @Nonnull @NotEmpty public static final String NAMESPACE = "urn:mace:shibboleth:2.0:resolver";

    /** {@inheritDoc} */
    // Checkstyle: MethodLength OFF
    @Override public void init() {
        final BeanDefinitionParser parser = new AttributeResolverParser();

        registerBeanDefinitionParser(AttributeResolverParser.SCHEMA_TYPE, parser);
        registerBeanDefinitionParser(AttributeResolverParser.ELEMENT_NAME, parser);
        registerBeanDefinitionParser(InputDataConnectorParser.ELEMENT_NAME, new InputDataConnectorParser());
        registerBeanDefinitionParser(InputAttributeDefinitionParser.ELEMENT_NAME, new InputAttributeDefinitionParser());

        // Attribute Resolvers
        registerBeanDefinitionParser(PrescopedAttributeDefinitionParser.TYPE_NAME,
                new PrescopedAttributeDefinitionParser());
        registerBeanDefinitionParser(PrincipalNameAttributeDefinitionParser.TYPE_NAME,
                new PrincipalNameAttributeDefinitionParser());
        registerBeanDefinitionParser(RegexSplitAttributeDefinitionParser.TYPE_NAME,
                new RegexSplitAttributeDefinitionParser());

        registerBeanDefinitionParser(SubjectDerivedAttributeDefinitionParser.TYPE_NAME,
                new SubjectDerivedAttributeDefinitionParser());
        registerBeanDefinitionParser(ContextDerivedAttributeDefinitionParser.TYPE_NAME,
                new ContextDerivedAttributeDefinitionParser());
        registerBeanDefinitionParser(SAML1NameIdentifierAttributeDefinitionParser.TYPE_NAME,
                new SAML1NameIdentifierAttributeDefinitionParser());
        registerBeanDefinitionParser(SAML2NameIDAttributeDefinitionParser.TYPE_NAME,
                new SAML2NameIDAttributeDefinitionParser());
        registerBeanDefinitionParser(ScopedAttributeDefinitionParser.TYPE_NAME,
                new ScopedAttributeDefinitionParser());
        registerBeanDefinitionParser(ScriptedAttributeDefinitionParser.TYPE_NAME,
                new ScriptedAttributeDefinitionParser());
        registerBeanDefinitionParser(SimpleAttributeDefinitionParser.TYPE_NAME,
                new SimpleAttributeDefinitionParser());
        registerBeanDefinitionParser(DecryptedAttributeDefinitionParser.TYPE_NAME,
                new DecryptedAttributeDefinitionParser());        
        registerBeanDefinitionParser(TemplateAttributeDefinitionParser.TYPE_NAME,
                new TemplateAttributeDefinitionParser());
        registerBeanDefinitionParser(SourceValueParser.TYPE_NAME_RESOLVER, new SourceValueParser());
        registerBeanDefinitionParser(ValueMapParser.TYPE_NAME_RESOLVER, new ValueMapParser());
        registerBeanDefinitionParser(MappedAttributeDefinitionParser.TYPE_NAME,
                new MappedAttributeDefinitionParser());
        registerBeanDefinitionParser(DateTimeAttributeDefinitionParser.TYPE_NAME,
                new DateTimeAttributeDefinitionParser());
        
        // Data Connectors
        registerBeanDefinitionParser(ComputedIdDataConnectorParser.TYPE_NAME, 
                new ComputedIdDataConnectorParser());
        registerBeanDefinitionParser(RDBMSDataConnectorParser.TYPE_NAME, new RDBMSDataConnectorParser());
        registerBeanDefinitionParser(LDAPDataConnectorParser.TYPE_NAME, new LDAPDataConnectorParser());
        registerBeanDefinitionParser(PairwiseIdDataConnectorParser.TYPE_NAME,
                new PairwiseIdDataConnectorParser());
        registerBeanDefinitionParser(HTTPDataConnectorParser.TYPE_NAME, new HTTPDataConnectorParser());
        registerBeanDefinitionParser(ScriptedDataConnectorParser.TYPE_NAME, new ScriptedDataConnectorParser());
        registerBeanDefinitionParser(StaticDataConnectorParser.TYPE_NAME, new StaticDataConnectorParser());
        registerBeanDefinitionParser(StoredIdDataConnectorParser.TYPE_NAME, new StoredIdDataConnectorParser());
        registerBeanDefinitionParser(SubjectDataConnectorParser.TYPE_NAME, new SubjectDataConnectorParser());
        registerBeanDefinitionParser(StorageServiceDataConnectorParser.TYPE_NAME,
                new StorageServiceDataConnectorParser());
        registerBeanDefinitionParser(EntityAttributesDataConnectorParser.TYPE_NAME,
                new EntityAttributesDataConnectorParser());


        // Encoders
        registerBeanDefinitionParser(SAML1StringAttributeEncoderParser.TYPE_NAME,
                new SAML1StringAttributeEncoderParser());
        registerBeanDefinitionParser(SAML1Base64AttributeEncoderParser.TYPE_NAME,
                new SAML1Base64AttributeEncoderParser());

        registerBeanDefinitionParser(SAML1ScopedStringAttributeEncoderParser.TYPE_NAME,
                new SAML1ScopedStringAttributeEncoderParser());

         registerBeanDefinitionParser(SAML1XMLObjectAttributeEncoderParser.TYPE_NAME,
                new SAML1XMLObjectAttributeEncoderParser());

        registerBeanDefinitionParser(SAML2Base64AttributeEncoderParser.TYPE_NAME,
                new SAML2Base64AttributeEncoderParser());

        registerBeanDefinitionParser(SAML2ScopedStringAttributeEncoderParser.TYPE_NAME,
                new SAML2ScopedStringAttributeEncoderParser());

        registerBeanDefinitionParser(SAML2StringAttributeEncoderParser.TYPE_NAME,
                new SAML2StringAttributeEncoderParser());

        registerBeanDefinitionParser(SAML2DateTimeAttributeEncoderParser.TYPE_NAME,
                new SAML2DateTimeAttributeEncoderParser());

        registerBeanDefinitionParser(SAML2XMLObjectAttributeEncoderParser.TYPE_NAME,
                new SAML2XMLObjectAttributeEncoderParser());
    }
    // Checkstyle: MethodLength ON

}
