/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.impl.ComputedPairwiseIdStore;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.PairwiseIdDataConnectorParser;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.AttributeSupport;
import org.slf4j.Logger;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ComputedIdDataConnectorParser
extends PairwiseIdDataConnectorParser {
    @Nonnull
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "ComputedId");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ComputedIdDataConnectorParser.class);
    @Nullable
    private final String servletRequestSupplier = ComputedIdDataConnectorParser.getCustomProperty((String)(((Object)((Object)this)).getClass().getName() + ".HttpServletRequestSupplier.bean"), null);

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder, "computedId");
        builder.addPropertyValue("pairwiseIdStore", (Object)this.doComputedPairwiseIdStore(config, parserContext));
    }

    @Nonnull
    protected BeanDefinition doComputedPairwiseIdStore(@Nonnull Element config, @Nonnull ParserContext parserContext) {
        String encodedSalt;
        String salt;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ComputedPairwiseIdStore.class);
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
        if (config.hasAttributeNS(null, "algorithm")) {
            builder.addPropertyValue("algorithm", (Object)config.getAttributeNS(null, "algorithm"));
        }
        if (config.hasAttributeNS(null, "encoding")) {
            builder.addPropertyValue("encoding", (Object)config.getAttributeNS(null, "encoding"));
        }
        if (config.hasAttributeNS(null, "exceptionMapRef")) {
            builder.addPropertyReference("exceptionMap", AttributeSupport.ensureAttributeValue((Element)config, null, (String)"exceptionMapRef"));
        }
        if (config.hasAttributeNS(null, "saltLookupStrategyRef")) {
            builder.addPropertyReference("saltLookupStrategy", AttributeSupport.ensureAttributeValue((Element)config, null, (String)"saltLookupStrategyRef"));
            if (this.servletRequestSupplier != null) {
                this.log.debug("Using bean ID '{}' as servlet request supplier", (Object)this.servletRequestSupplier);
                assert (this.servletRequestSupplier != null);
                builder.addPropertyReference("httpServletRequestSupplier", this.servletRequestSupplier);
            } else {
                this.log.warn("No HttpServletRequest supplier available to inject into connector for salt lookup strategy");
            }
        }
        if (config.hasAttributeNS(null, "salt")) {
            salt = config.getAttributeNS(null, "salt");
            encodedSalt = null;
            if (config.hasAttributeNS(null, "encodedSalt")) {
                this.log.warn("{} Ignoring encodedSalt in favor of salt", (Object)this.getLogPrefix());
            }
        } else if (config.hasAttributeNS(null, "encodedSalt")) {
            salt = null;
            encodedSalt = config.getAttributeNS(null, "encodedSalt");
        } else {
            encodedSalt = null;
            salt = null;
        }
        if (salt != null) {
            this.log.debug("{} See TRACE log for the salt value", (Object)this.getLogPrefix());
            this.log.trace("{} Salt: '{}'", (Object)this.getLogPrefix(), (Object)salt);
            builder.addPropertyValue("salt", (Object)salt);
        } else if (encodedSalt != null) {
            this.log.debug("{} See TRACE log for the salt value", (Object)this.getLogPrefix());
            this.log.trace("{} Encoded Salt: '{}'", (Object)this.getLogPrefix(), (Object)encodedSalt);
            builder.addPropertyValue("encodedSalt", (Object)encodedSalt);
        } else {
            this.log.debug("{} No salt provided", (Object)this.getLogPrefix());
        }
        return builder.getBeanDefinition();
    }
}

