/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.ResolverDataConnectorDependency;
import net.shibboleth.idp.attribute.resolver.spring.BaseResolverPluginDependencyParser;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.util.SpringSupport;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class InputDataConnectorParser
extends BaseResolverPluginDependencyParser {
    @Nonnull
    public static final QName ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "InputDataConnector");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InputDataConnectorParser.class);

    @Nullable
    protected Class<ResolverDataConnectorDependency> getBeanClass(@Nonnull Element element) {
        return ResolverDataConnectorDependency.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        Attr attributes = config.getAttributeNodeNS(null, "attributeNames");
        String allAttributes = StringSupport.trimOrNull((String)config.getAttributeNS(null, "allAttributes"));
        if (attributes != null) {
            if (allAttributes != null) {
                this.log.error("attributeNames and allAttributes are mutually exclusive");
                throw new BeanCreationException(ELEMENT_NAME.getLocalPart() + ": attributeNames and allAttributes are mutually exclusive");
            }
            builder.addPropertyValue("attributeNames", (Object)SpringSupport.getAttributeValueAsList((Attr)attributes));
        } else if (allAttributes != null) {
            builder.addPropertyValue("allAttributes", (Object)allAttributes);
        } else {
            this.log.error("One of attributeNames or allAttributes must be specified");
            throw new BeanCreationException(ELEMENT_NAME.getLocalPart() + ": One of attributeNames or allAttributes must be specified ");
        }
    }
}

