/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.idp.saml.xmlobject;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;

import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.schema.XSString;

import net.shibboleth.shared.annotation.constraint.NotEmpty;

/** XMLObject for the Shibboleth Scope metadata extension. */
public interface Scope extends XSString {

    /** Element local name. */
    @Nonnull @NotEmpty static final String DEFAULT_ELEMENT_LOCAL_NAME = "Scope";

    /** Default element name. */
    @Nonnull static final QName DEFAULT_ELEMENT_NAME = new QName(ExtensionsConstants.SHIB_MDEXT10_NS,
            DEFAULT_ELEMENT_LOCAL_NAME, ExtensionsConstants.SHIB_MDEXT10_PREFIX);

    /** regexp attribute name. */
    @Nonnull @NotEmpty static final String REGEXP_ATTRIB_NAME = "regexp";

    /**
     * Get the regexp attribute value.
     * 
     * @return the regexp attribute value
     */
    @Nullable Boolean getRegexp();

    /**
     * Get the regexp attribute value.
     * 
     * @return the regexp attribute value
     */
    @Nullable XSBooleanValue getRegexpXSBoolean();

    /**
     * Set the regexp attribute value.
     * 
     * @param newRegexp the new regexp attribute value
     */
    void setRegexp(@Nullable final Boolean newRegexp);

    /**
     * Set the regexp attribute value.
     * 
     * @param newRegexp the new regexp attribute value
     */
    void setRegexp(@Nullable final XSBooleanValue newRegexp);

}