/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.idp.saml.xmlobject.impl;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.slf4j.Logger;
import org.w3c.dom.Attr;

import net.shibboleth.idp.saml.xmlobject.Scope;
import net.shibboleth.shared.primitive.LoggerFactory;

/** Unmarshaller for {@link Scope}. */
@ThreadSafe
public class ScopeUnmarshaller extends AbstractXMLObjectUnmarshaller {

    /** Logger. */
    private final Logger log = LoggerFactory.getLogger(ScopeUnmarshaller.class);

    /** {@inheritDoc} */
    protected void processAttribute(final @Nonnull XMLObject xmlObject, final @Nonnull Attr attribute)
            throws UnmarshallingException {
        final Scope scope = (Scope) xmlObject;

        if (attribute.getLocalName().equals(Scope.REGEXP_ATTRIB_NAME)) {
            scope.setRegexp(Boolean.valueOf(attribute.getValue()));
        } else {
            super.processAttribute(xmlObject, attribute);
        }

    }

    /** {@inheritDoc} */
    protected void processElementContent(final @Nonnull XMLObject xmlObject, final @Nonnull String elementContent) {
        final Scope scope = (Scope) xmlObject;
        scope.setValue(elementContent);
    }

}