/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.metadata.impl;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.spring.service.AbstractServiceableComponent;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.slf4j.Logger;

public class MetadataProviderContainer
extends AbstractServiceableComponent<MetadataResolver>
implements Comparable<MetadataProviderContainer> {
    private static int sortKeyValue;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(MetadataProviderContainer.class);
    @NonnullAfterInit
    private MetadataResolver resolver;
    @NonnullAfterInit
    private Integer sortKey;

    public void setSortKey(int key) {
        this.checkSetterPreconditions();
        this.sortKey = key;
    }

    public void setEmbeddedResolver(@Nonnull MetadataResolver theResolver) {
        this.checkSetterPreconditions();
        this.resolver = (MetadataResolver)Constraint.isNotNull((Object)theResolver, (String)"MetadataResolver cannot be null");
    }

    @NonnullAfterInit
    public MetadataResolver getEmbeddedResolver() {
        return this.resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doInitialize() throws ComponentInitializationException {
        if (null == this.resolver) {
            throw new ComponentInitializationException("MetadataResolver cannot be null");
        }
        String embeddedId = this.resolver.getId();
        if (embeddedId == null) {
            throw new ComponentInitializationException("Embedded MetadataResolver has no ID");
        }
        this.setId(embeddedId);
        super.doInitialize();
        if (null != this.sortKey) return;
        Class<MetadataProviderContainer> clazz = MetadataProviderContainer.class;
        synchronized (MetadataProviderContainer.class) {
            this.sortKey = ++sortKeyValue;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.log.info("Top level Metadata Provider '{}' did not have a sort key; giving it value '{}'", (Object)this.getId(), (Object)this.sortKey);
            return;
        }
    }

    @Override
    public int compareTo(MetadataProviderContainer other) {
        this.checkComponentActive();
        int result = this.sortKey.compareTo(other.sortKey);
        if (result != 0) {
            return result;
        }
        if (this.equals(other)) {
            return 0;
        }
        return this.ensureId().compareTo(other.ensureId());
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (!(other instanceof MetadataProviderContainer)) {
            return false;
        }
        MetadataProviderContainer otherRp = (MetadataProviderContainer)other;
        return Objects.equals(otherRp.sortKey, this.sortKey) && Objects.equals(this.getId(), otherRp.getId());
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.sortKey, this.getId()});
    }

    @Nonnull
    public MetadataResolver getComponent() {
        this.checkComponentActive();
        MetadataResolver result = this.getEmbeddedResolver();
        assert (result != null);
        return result;
    }
}

