/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.servlet.impl;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.servlet.AbstractConditionalFilter;
import net.shibboleth.shared.spring.servlet.ChainableFilter;
import org.springframework.beans.factory.annotation.Autowired;

public class ChainingFilter
implements Filter {
    @Nullable
    private List<ChainableFilter> filters;

    @Autowired
    public ChainingFilter(@Nullable Collection<ChainableFilter> filterChain) {
        this.filters = filterChain != null ? List.copyOf(filterChain) : null;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.filters != null && !this.filters.isEmpty()) {
            new Chain(chain).doFilter(request, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    private class Chain
    implements FilterChain {
        @Nonnull
        private Iterator<ChainableFilter> iterator;
        @Nonnull
        private FilterChain outerChain;

        public Chain(FilterChain outer) {
            assert (ChainingFilter.this.filters != null);
            this.iterator = ChainingFilter.this.filters.iterator();
            this.outerChain = outer;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.iterator.hasNext()) {
                ChainableFilter filter = this.iterator.next();
                if (filter instanceof AbstractConditionalFilter && !((AbstractConditionalFilter)filter).getActivationCondition().test(request)) {
                    this.doFilter(request, response);
                    return;
                }
                filter.doFilter(request, response, this);
            } else {
                this.outerChain.doFilter(request, response);
            }
        }
    }
}

