/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.shared.spring.servlet;

import javax.annotation.Nonnull;

import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

/** Used to allow for auto-wiring of values into {@link RequestURLPrefixPredicate}. */
public class URLPrefix {
    
    /** The wrapped string. */
    @Nonnull @NotEmpty private final String wrappedString;
    
    /**
     * Constructor.
     *
     * @param s string to wrap
     */
    public URLPrefix(@Nonnull @NotEmpty @ParameterName(name="s") final String s) {
        wrappedString = Constraint.isNotNull(StringSupport.trimOrNull(s), "Input string cannot be null or empty");
    }
    
    /**
     * Get the wrapped value.
     * 
     * @return wrapped value
     */
    @Nonnull @NotEmpty public String getValue() {
        return wrappedString;
    }

}