/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.servlet;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.spring.servlet.URLPrefix;
import org.springframework.beans.factory.annotation.Autowired;

public class RequestURLPrefixPredicate
implements Predicate<ServletRequest> {
    @Nonnull
    private Collection<URLPrefix> matchingPrefixes;

    @Autowired
    public RequestURLPrefixPredicate(@Nullable @ParameterName(name="prefixes") Collection<URLPrefix> prefixes) {
        this.matchingPrefixes = prefixes != null ? CollectionSupport.copyToList(prefixes) : CollectionSupport.emptyList();
    }

    @Override
    public boolean test(@Nullable ServletRequest input) {
        if (input instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)input;
            String uri = req.getRequestURI();
            for (URLPrefix p : this.matchingPrefixes) {
                if (!uri.startsWith(input.getServletContext().getContextPath() + p.getValue())) continue;
                return true;
            }
        }
        return false;
    }
}

