/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.shared.httpclient;

import java.net.InetAddress;
import java.net.ProxySelector;

import javax.annotation.Nullable;

import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.impl.routing.SystemDefaultRoutePlanner;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;

/**
 * Extension of {@link SystemDefaultRoutePlanner} which allows supplying a static local address.
 */
public class LocalAddressSystemRoutePlanner extends SystemDefaultRoutePlanner {
    
    /** The local address. */
    @Nullable private final InetAddress address;

    /**
     * Constructor.
     * 
     * @param localAddress the local address
     * @param schemePortResolver the schema port resolver
     * @param proxySelector the proxy selector
     */
    public LocalAddressSystemRoutePlanner(@Nullable final InetAddress localAddress,
            @Nullable final SchemePortResolver schemePortResolver, @Nullable final ProxySelector proxySelector) {
        super(schemePortResolver, proxySelector);
        address = localAddress;
    }
    
    /** {@inheritDoc} */
    @Override
    @Nullable protected InetAddress determineLocalAddress(final HttpHost firstHop, final HttpContext context)
            throws HttpException {
        return address;
    }

}