/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.transcoding;

import com.google.common.base.Strings;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeDecodingException;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.IdPRequestedAttribute;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.saml.attribute.transcoding.AbstractSAMLAttributeTranscoder;
import net.shibboleth.idp.saml.attribute.transcoding.SAML2AttributeTranscoder;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;
import org.slf4j.Logger;

public abstract class AbstractSAML2AttributeTranscoder<EncodedType extends IdPAttributeValue>
extends AbstractSAMLAttributeTranscoder<Attribute, EncodedType>
implements SAML2AttributeTranscoder<EncodedType> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractSAML2AttributeTranscoder.class);
    @Nonnull
    private final SAMLObjectBuilder<Attribute> attributeBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(Attribute.TYPE_NAME);
    @Nonnull
    private final SAMLObjectBuilder<RequestedAttribute> reqAttributeBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(RequestedAttribute.TYPE_NAME);

    @Nonnull
    public Class<Attribute> getEncodedType() {
        return Attribute.class;
    }

    @Nullable
    public String getEncodedName(@Nonnull TranscodingRule rule) {
        try {
            return new NamingFunction().apply(this.buildAttribute((ProfileRequestContext)null, (IdPAttribute)null, (Class<? extends Attribute>)Attribute.class, rule, (List<XMLObject>)CollectionSupport.emptyList()));
        }
        catch (AttributeEncodingException e) {
            return null;
        }
    }

    @Override
    @Nonnull
    protected Attribute buildAttribute(@Nullable ProfileRequestContext profileRequestContext, @Nullable IdPAttribute attribute, @Nonnull Class<? extends Attribute> to, @Nonnull TranscodingRule rule, @Nonnull List<XMLObject> attributeValues) throws AttributeEncodingException {
        Attribute samlAttribute;
        if (attribute != null && !attribute.getValues().isEmpty() && attributeValues.isEmpty()) {
            throw new AttributeEncodingException("Failed to encode any values for attribute " + attribute.getId());
        }
        if (to.equals(Attribute.class)) {
            samlAttribute = (Attribute)this.attributeBuilder.buildObject();
        } else if (to.equals(RequestedAttribute.class)) {
            samlAttribute = (Attribute)this.reqAttributeBuilder.buildObject();
            if (attribute instanceof IdPRequestedAttribute) {
                ((RequestedAttribute)samlAttribute).setIsRequired(Boolean.valueOf(((IdPRequestedAttribute)attribute).isRequired()));
            }
        } else {
            throw new AttributeEncodingException("Unsupported target object type: " + to.getName());
        }
        this.encodeName(profileRequestContext, attribute, samlAttribute, rule);
        samlAttribute.getAttributeValues().addAll(attributeValues);
        String friendlyName = (String)rule.getOrDefault("saml2.friendlyName", String.class, (Object)(attribute != null ? attribute.getId() : ""));
        if (friendlyName != null && !friendlyName.isBlank()) {
            samlAttribute.setFriendlyName(friendlyName);
        }
        return samlAttribute;
    }

    protected void encodeName(@Nullable ProfileRequestContext profileRequestContext, @Nullable IdPAttribute attribute, @Nonnull Attribute samlAttribute, @Nonnull TranscodingRule rule) throws AttributeEncodingException {
        String name;
        Boolean useMetadata = (Boolean)rule.getOrDefault("saml2.nameFromMetadata", Boolean.class, (Object)false);
        if (useMetadata != null && useMetadata.booleanValue()) {
            String id;
            String string = id = attribute != null ? attribute.getId() : (String)rule.get("id", String.class);
            if (id == null) {
                this.log.warn("Rule specified {} but no attribute ID available", (Object)"saml2.nameFromMetadata");
            } else {
                String tagValue = this.getNameFromMetadata(profileRequestContext, id);
                if (tagValue != null) {
                    String nameFormat;
                    String name2;
                    int lastSpace = tagValue.lastIndexOf(32);
                    if (lastSpace < 0) {
                        name2 = StringSupport.trimOrNull((String)tagValue);
                        nameFormat = null;
                    } else {
                        name2 = StringSupport.trimOrNull((String)tagValue.substring(0, lastSpace));
                        nameFormat = StringSupport.trimOrNull((String)tagValue.substring(lastSpace));
                    }
                    if (name2 != null) {
                        samlAttribute.setName(name2);
                        samlAttribute.setNameFormat(nameFormat);
                        this.log.debug("Encoding IdPAttribute {} via metadata tag as Name {}, NameFormat {}", new Object[]{id, name2, nameFormat});
                        return;
                    }
                    this.log.warn("Metadata tag {}, value {}, was not in the expected form", (Object)"http://shibboleth.net/ns/attributes/naming/saml2", (Object)tagValue);
                }
            }
        }
        if (Strings.isNullOrEmpty((String)(name = (String)rule.get("saml2.name", String.class)))) {
            throw new AttributeEncodingException("Required transcoder property 'saml2.name' not found");
        }
        samlAttribute.setName(name);
        samlAttribute.setNameFormat((String)rule.getOrDefault("saml2.nameFormat", String.class, (Object)"urn:oasis:names:tc:SAML:2.0:attrname-format:uri"));
    }

    @Override
    @Nonnull
    protected IdPAttribute buildIdPAttribute(@Nullable ProfileRequestContext profileRequestContext, @Nonnull Attribute attribute, @Nonnull TranscodingRule rule, @Nonnull List<IdPAttributeValue> attributeValues) throws AttributeDecodingException {
        IdPAttribute idpAttribute;
        if (!attribute.getAttributeValues().isEmpty() && attributeValues.isEmpty()) {
            throw new AttributeDecodingException("Failed to decode any values for attribute " + attribute.getName());
        }
        String id = (String)rule.get("id", String.class);
        if (Strings.isNullOrEmpty((String)id)) {
            throw new AttributeDecodingException("Required transcoder property 'id' not found");
        }
        assert (id != null);
        if (attribute instanceof RequestedAttribute) {
            RequestedAttribute reqAttribute = (RequestedAttribute)attribute;
            idpAttribute = new IdPRequestedAttribute(id);
            Boolean isRequired = reqAttribute.isRequired();
            if (isRequired != null) {
                ((IdPRequestedAttribute)idpAttribute).setRequired(isRequired.booleanValue());
            }
        } else {
            idpAttribute = new IdPAttribute(id);
        }
        idpAttribute.setValues(attributeValues);
        return idpAttribute;
    }

    @Override
    @Nonnull
    protected Iterable<XMLObject> getValues(@Nonnull Attribute input) {
        return input.getAttributeValues();
    }

    public static class NamingFunction
    implements Function<Attribute, String> {
        @Override
        @Nullable
        public String apply(@Nullable Attribute input) {
            if (input == null || input.getName() == null) {
                return null;
            }
            String format = input.getNameFormat();
            if (format == null) {
                format = "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified";
            }
            StringBuilder builder = new StringBuilder();
            builder.append("SAML2:{").append(format).append('}').append(input.getName());
            return builder.toString();
        }
    }
}

