/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.config;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.IdentifiedComponent;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class IdentifiedComponentManager<T extends IdentifiedComponent> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(IdentifiedComponentManager.class);
    @Nonnull
    private Collection<T> initialComponents;
    @Nonnull
    private Collection<T> components;

    public IdentifiedComponentManager(@Nullable Collection<T> freeObjects) {
        this.initialComponents = freeObjects != null ? CollectionSupport.copyToList(freeObjects) : CollectionSupport.emptyList();
        this.components = this.initialComponents;
    }

    public void setComponents(@Nullable Collection<T> additionalObjects) {
        if (additionalObjects != null) {
            LinkedHashSet<T> holder = new LinkedHashSet<T>(additionalObjects);
            holder.addAll(this.initialComponents.stream().filter(obj -> {
                if (holder.contains(obj)) {
                    this.log.info("Replacing auto-wired component: {}", (Object)obj.getId());
                    return false;
                }
                return true;
            }).collect(Collectors.toUnmodifiableList()));
            this.components = CollectionSupport.copyToList(holder);
        } else {
            this.components = this.initialComponents;
        }
    }

    @Nonnull
    public Collection<T> getComponents() {
        return this.components;
    }
}

