/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.custom;

import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.spring.custom.SchemaTypeAwareBeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.DefaultBeanDefinitionDocumentReader;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class SchemaTypeAwareBeanDefinitionDocumentReader
extends DefaultBeanDefinitionDocumentReader {
    protected void importBeanDefinitionResource(@Nonnull Element ele) {
        String location = ele.getAttribute("resource");
        if (!StringUtils.hasText((String)location)) {
            this.getReaderContext().error("Resource location must not be empty", (Object)ele);
            return;
        }
        assert (location != null);
        location = this.getReaderContext().getEnvironment().resolveRequiredPlaceholders(location);
        if (location.startsWith("classpath*:")) {
            this.logger.debug((Object)"Wildcard classpath syntax, delegating to default behavior");
            super.importBeanDefinitionResource(ele);
            return;
        }
        LinkedHashSet<Resource> actualResources = new LinkedHashSet<Resource>(4);
        ResourceLoader loader = this.getReaderContext().getResourceLoader();
        Resource r = loader != null ? loader.getResource(location) : null;
        boolean exists = false;
        try {
            exists = r != null ? r.exists() : false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (exists && r != null) {
            int importCount = this.getReaderContext().getReader().loadBeanDefinitions(r);
            actualResources.add(r);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Imported " + importCount + " bean definitions from location [" + location + "]"));
            }
            Resource[] actResArray = actualResources.toArray(new Resource[0]);
            assert (actResArray != null);
            this.getReaderContext().fireImportProcessed(location, actResArray, this.extractSource(ele));
        } else {
            this.logger.debug((Object)("Resource location [" + location + "] does not exist, delegating to default behavior"));
            super.importBeanDefinitionResource(ele);
        }
    }

    @Nonnull
    protected BeanDefinitionParserDelegate createDelegate(@Nonnull XmlReaderContext readerContext, @Nonnull Element root, @Nullable BeanDefinitionParserDelegate parentDelegate) {
        SchemaTypeAwareBeanDefinitionParserDelegate delegate = new SchemaTypeAwareBeanDefinitionParserDelegate(readerContext);
        delegate.initDefaults(root, parentDelegate);
        return delegate;
    }
}

