/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.custom;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.custom.SecondaryNamespaceHandler;
import net.shibboleth.shared.xml.DOMTypeSupport;
import net.shibboleth.shared.xml.QNameSupport;
import org.slf4j.Logger;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseSpringNamespaceHandler
implements NamespaceHandler {
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_SECONDARY_HANDLER_BASE_LOCATION = "META-INF/net/shibboleth/spring/handlers/";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseSpringNamespaceHandler.class);
    @Nullable
    @NotEmpty
    private final String secondaryHandlerQualifier;
    @Nonnull
    private final Map<QName, BeanDefinitionParser> parsers = new HashMap<QName, BeanDefinitionParser>();

    public BaseSpringNamespaceHandler() {
        this(null);
    }

    public BaseSpringNamespaceHandler(@Nullable @ParameterName(name="qualifier") @NotEmpty String qualifier) {
        this.secondaryHandlerQualifier = StringSupport.trimOrNull((String)qualifier);
    }

    public void init() {
        this.doInit();
        if (this.secondaryHandlerQualifier != null) {
            this.initSecondaryHandlers();
        }
    }

    @Nonnull
    public BeanDefinitionHolder decorate(@Nonnull Node node, @Nonnull BeanDefinitionHolder definition, @Nonnull ParserContext parserContext) {
        return definition;
    }

    @Nullable
    public BeanDefinition parse(@Nonnull Element element, @Nonnull ParserContext parserContext) {
        return this.findParserForElement(element).parse(element, parserContext);
    }

    protected void doInit() {
    }

    @Nonnull
    protected BeanDefinitionParser findParserForElement(@Nonnull Element element) {
        BeanDefinitionParser parser = null;
        QName typeName = DOMTypeSupport.getXSIType((Element)element);
        if (typeName != null) {
            this.log.trace("Attempting to find parser for element of type: {}", (Object)typeName);
            parser = this.parsers.get(typeName);
        }
        QName elementName = null;
        if (parser == null) {
            elementName = QNameSupport.getNodeQName((Node)element);
            this.log.trace("Attempting to find parser with element name: {}", (Object)elementName);
            parser = this.parsers.get(elementName);
        }
        if (parser == null) {
            String msg = "Can not locate BeanDefinitionParser for element: " + elementName;
            if (typeName != null) {
                msg = msg + ", carrying xsi:type: " + typeName;
            }
            this.log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        return parser;
    }

    protected void registerBeanDefinitionParser(@Nonnull QName elementNameOrType, @Nonnull BeanDefinitionParser parser) {
        this.parsers.put(elementNameOrType, parser);
    }

    private void initSecondaryHandlers() {
        try {
            Enumeration<URL> urls = ClassLoader.getSystemResources(DEFAULT_SECONDARY_HANDLER_BASE_LOCATION + this.secondaryHandlerQualifier);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                URLConnection con = url.openConnection();
                InputStream is = con.getInputStream();
                try (InputStreamReader isr = new InputStreamReader(is);
                     BufferedReader br = new BufferedReader(isr);){
                    String className = br.readLine();
                    Class<?> clazz = Class.forName(className);
                    assert (clazz != null);
                    SecondaryNamespaceHandler namespaceHandler = (SecondaryNamespaceHandler)BeanUtils.instantiateClass(clazz);
                    namespaceHandler.init(this.parsers);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (IOException | ClassCastException | ClassNotFoundException | BeanInstantiationException e) {
            this.log.error("Secondary initialization failed for namespace {}", (Object)this.secondaryHandlerQualifier, (Object)e);
            throw new BeanCreationException("Secondary initialization failed for namespace '" + this.secondaryHandlerQualifier + "'", e);
        }
    }
}

