/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.custom;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.xml.DOMTypeSupport;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.w3c.dom.Element;

public class SchemaTypeAwareBeanDefinitionParserDelegate
extends BeanDefinitionParserDelegate {
    public SchemaTypeAwareBeanDefinitionParserDelegate(XmlReaderContext readerContext) {
        super(readerContext);
    }

    public BeanDefinition parseCustomElement(@Nonnull Element element) {
        return this.parseCustomElement(element, null);
    }

    public BeanDefinition parseCustomElement(@Nonnull Element element, @Nullable BeanDefinition containingBd) {
        QName type;
        String namespaceUri = element.getNamespaceURI();
        if (DOMTypeSupport.hasXSIType((Element)element) && (type = DOMTypeSupport.getXSIType((Element)element)) != null) {
            namespaceUri = type.getNamespaceURI();
        }
        assert (namespaceUri != null);
        NamespaceHandler handler = this.getReaderContext().getNamespaceHandlerResolver().resolve(namespaceUri);
        if (handler == null) {
            this.error("Unable to locate NamespaceHandler for namespace [" + namespaceUri + "]", element);
            return null;
        }
        return handler.parse(element, new ParserContext(this.getReaderContext(), (BeanDefinitionParserDelegate)this, containingBd));
    }
}

