/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.expression;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.spring.expression.AbstractSpringExpressionEvaluator;
import org.slf4j.Logger;
import org.springframework.expression.EvaluationContext;

public class SpringExpressionFunction<T, U>
extends AbstractSpringExpressionEvaluator
implements Function<T, U> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SpringExpressionFunction.class);
    @Nullable
    private Class<T> inputType;

    public SpringExpressionFunction(@Nonnull @ParameterName(name="expression") @NotEmpty String expression) {
        super(expression);
    }

    @Nullable
    public Class<T> getInputType() {
        return this.inputType;
    }

    public void setInputType(@Nullable Class<T> type) {
        this.inputType = type;
    }

    @Override
    public void setOutputType(@Nullable Class<?> type) {
        super.setOutputType(type);
    }

    @Override
    public void setReturnOnError(@Nullable Object value) {
        super.setReturnOnError(value);
    }

    @Override
    public U apply(@Nullable T input) {
        Class<T> itype = this.getInputType();
        if (null != itype && null != input && !itype.isInstance(input)) {
            this.log.error("Input was type {} which is not an instance of {}", input.getClass(), this.getInputType());
            throw new ClassCastException("Input was type " + input.getClass() + " which is not an instance of " + itype);
        }
        return (U)this.evaluate(input);
    }

    @Override
    protected void prepareContext(@Nonnull EvaluationContext context, Object ... input) {
        context.setVariable("input", input != null ? input[0] : null);
    }
}

