/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class RunnableFileSystemResource
extends FileSystemResource
implements net.shibboleth.shared.resource.Resource,
Resource {
    @Nonnull
    private final Runnable theRunnable;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RunnableFileSystemResource.class);
    @Nonnull
    @NotEmpty
    private final String thePrefix;

    public RunnableFileSystemResource(@Nonnull @ParameterName(name="file") File file, @Nonnull @ParameterName(name="runnable") Runnable runnable) {
        super((File)Constraint.isNotNull((Object)file, (String)"File parameter to RunnableFileSystemResource cannot be null"));
        this.theRunnable = (Runnable)Constraint.isNotNull((Object)runnable, (String)"Runnable parameter to RunnableFileSystemResource cannot be null");
        this.thePrefix = "RunnableResource [" + this.getPath() + "]";
        try {
            this.callRunnable();
        }
        catch (IOException ex) {
            throw new BeanCreationException(ex.getMessage());
        }
    }

    public RunnableFileSystemResource(@Nonnull @ParameterName(name="path") @NotEmpty String path, @Nonnull @ParameterName(name="runnable") Runnable runnable) {
        super(Constraint.isNotEmpty((String)path, (String)"Path parameter to RunnableFileSystemResource cannot be null"));
        this.theRunnable = (Runnable)Constraint.isNotNull((Object)runnable, (String)"Runnable parameter to RunnableFileSystemResource cannot be null");
        this.thePrefix = "RunnableResource [" + this.getPath() + "]";
        try {
            this.callRunnable();
        }
        catch (IOException ex) {
            throw new BeanCreationException(ex.getMessage());
        }
    }

    @Nonnull
    public RunnableFileSystemResource createRelativeResource(@Nonnull String relativePath) throws IOException {
        return new RunnableFileSystemResource(super.createRelative(relativePath).getFile(), this.theRunnable);
    }

    public boolean exists() {
        try {
            this.callRunnable();
        }
        catch (IOException e) {
            return false;
        }
        return super.exists();
    }

    @Nonnull
    public InputStream getInputStream() throws IOException {
        this.callRunnable();
        return super.getInputStream();
    }

    public long lastModified() throws IOException {
        this.callRunnable();
        return super.lastModified();
    }

    protected void callRunnable() throws IOException {
        try {
            this.theRunnable.run();
        }
        catch (Exception ex) {
            this.log.error("{} : Runnable failed: {}", (Object)this.thePrefix, (Object)ex.getMessage());
            throw new IOException(ex);
        }
    }
}

