/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.ext.spring.context;

import net.shibboleth.shared.primitive.DeprecationSupport;
import net.shibboleth.shared.primitive.DeprecationSupport.ObjectType;

/**
 * This is a stub to preserve compatibility for old web.xml references to this class.
 * 
 * @deprecated
 */
@Deprecated(forRemoval=true, since="9.0.0")
public class DelimiterAwareApplicationContext
        extends net.shibboleth.shared.spring.context.DelimiterAwareApplicationContext {

    /** Constructor. */
    @SuppressWarnings("null")
    public DelimiterAwareApplicationContext() {
        DeprecationSupport.warn(ObjectType.CLASS, getClass().getName(), "web.xml",
                "auto-registration via updated web.xml");
    }

}