/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.ext.spring.config;

import javax.annotation.Nonnull;

import net.shibboleth.shared.component.IdentifiableComponent;
import net.shibboleth.shared.primitive.DeprecationSupport;
import net.shibboleth.shared.primitive.DeprecationSupport.ObjectType;

/**
 * Pre-processes {@link IdentifiableComponent} beans by setting the bean ID to the bean name.
 */
public class IdentifiableBeanPostProcessor extends net.shibboleth.shared.spring.config.IdentifiableBeanPostProcessor {

    /** {@inheritDoc} */
    @SuppressWarnings("null")
    @Nonnull public Object postProcessBeforeInitialization(@Nonnull final Object bean, @Nonnull final String beanName) {
        
        DeprecationSupport.warn(ObjectType.CLASS, getClass().getName(), null,
                net.shibboleth.shared.spring.config.IdentifiableBeanPostProcessor.class.getName());

        return super.postProcessBeforeInitialization(bean, beanName);
    }

}