/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.testing;

import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

public final class RepositorySupport {
    private RepositorySupport() {
    }

    @Nonnull
    public static String buildHTTPSResourceURL(@Nonnull String repoName, @Nonnull String resourcePath) {
        return RepositorySupport.buildHTTPResourceURL(repoName, resourcePath, true, "HEAD");
    }

    @Nonnull
    public static String buildHTTPResourceURL(@Nonnull String repoName, @Nonnull String resourcePath, boolean https) {
        return RepositorySupport.buildHTTPResourceURL(repoName, resourcePath, https, "HEAD");
    }

    @Nonnull
    public static String buildHTTPResourceURL(@Nonnull String repoName, @Nonnull String resourcePath, boolean https, @Nonnull @NotEmpty String branch) {
        String repo = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)repoName), (String)"Repository name was null or empty");
        String path = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)resourcePath), (String)"Resource path was null or empty");
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (https) {
            return String.format("https://test.shibboleth.net/git/view/?p=%s.git&a=blob_plain&f=%s&hb=%s", repo, path, branch);
        }
        return String.format("http://git.shibboleth.net/view/?p=%s.git&a=blob_plain&f=%s&hb=%s", repo, path, branch);
    }
}

