/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.shared.testing;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import net.shibboleth.shared.service.AbstractReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import net.shibboleth.shared.spring.service.impl.SpringServiceableComponent;

/**
 * Utility class for wrapping a serviceable component in a dummy reloadable service.
 * 
 * @param <T> type of component
 */
public class MockReloadableService<T> extends AbstractReloadableService<T> {

    /** The component we are presenting to provide. */
    @Nullable private final SpringServiceableComponent<T> component;

    /**
     * Constructor.
     *
     * @param what component
     */
    public MockReloadableService(@Nullable final T what) {
        if (what == null) {
            component = null;
        } else {
            component = new SpringServiceableComponent<>(what);
        }
    }

    /** {@inheritDoc} */
    @Override
    @Nonnull public ServiceableComponent<T> getServiceableComponent() {
        final SpringServiceableComponent<T> result = component;
        if (null == result) {
            throw new ServiceException("Mock component is null");
        }
        result.pinComponent();
        return result;
    }

    /** {@inheritDoc} */
    @Override
    protected boolean shouldReload() {
        return false;
    }

}