/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.velocity;

import java.util.Locale;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.spring.velocity.VelocityView;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.AbstractTemplateViewResolver;

public class VelocityViewResolver
extends AbstractTemplateViewResolver {
    @Nonnull
    private final Predicate<String> activationCondition;

    public VelocityViewResolver() {
        this(PredicateSupport.alwaysTrue());
    }

    public VelocityViewResolver(@Nonnull @ParameterName(name="condition") Predicate<String> condition) {
        this.setViewClass(VelocityView.class);
        this.activationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Activation condition cannot be null");
    }

    @Nullable
    public View resolveViewName(@Nonnull String viewName, @Nonnull Locale locale) throws Exception {
        return this.activationCondition.test(viewName) ? super.resolveViewName(viewName, locale) : null;
    }
}

