/*
 * Decompiled with CFR 0.152.
 */
package net.smartcosmos.edge.things.resource;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Map;
import javax.validation.Valid;
import net.smartcosmos.annotation.SmartCosmosRdao;
import net.smartcosmos.edge.things.domain.RestEdgeThingCreateResponseDto;
import net.smartcosmos.edge.things.service.CreateThingEdgeService;
import net.smartcosmos.security.user.SmartCosmosUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.async.DeferredResult;

@SmartCosmosRdao
@Api
@ConditionalOnProperty(prefix="smartcosmos.endpoints.edge.things", name={"enabled"}, matchIfMissing=true)
public class CreateThingResource {
    private static final Logger log = LoggerFactory.getLogger(CreateThingResource.class);
    CreateThingEdgeService createThingService;

    @Autowired
    public CreateThingResource(CreateThingEdgeService createThingService) {
        this.createThingService = createThingService;
    }

    @ApiOperation(value="Create (or upsert) a new thing with an embedded set of metadata", notes="This endpoint is idempotent and will respond with an appropriate HTTP status code to indicate the actual result, ONLY when used without the force URL parameter, or when ?force=false. When the URL parameter ?force=true is set, this method behaves as an upsert, creating new thing and metadata or updating an existing thing and its metadata as appropriate, and with no idempotency guarantees.", response=RestEdgeThingCreateResponseDto.class)
    @ApiResponses(value={@ApiResponse(code=409, message="A Thing with the given urn already exists. No data is merged; existing record is left as-is."), @ApiResponse(code=201, message="A new Thing was added successfully.")})
    @RequestMapping(value={"/{type}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"}, consumes={"application/json;charset=UTF-8"})
    @ConditionalOnProperty(prefix="smartcosmos.endpoints.edge.things.create", name={"enabled"}, matchIfMissing=true)
    public DeferredResult<ResponseEntity> create(@ApiParam(value="Case-insensitive Thing type to create.", required=true, example="building") @PathVariable(value="type") String type, @ApiParam(value="Force API to behave as an upsert and update data if a thing already exists.", required=false, defaultValue="false") @RequestParam(name="force", required=false, defaultValue="false") boolean force, @ApiParam(value="The standard fields to create a new Thing.", required=true) @RequestBody @Valid Map<String, Object> metadataMap, SmartCosmosUser user) {
        DeferredResult response = new DeferredResult();
        this.createThingService.create((DeferredResult<ResponseEntity>)response, type, metadataMap, force, user);
        return response;
    }
}

