/*
 * Decompiled with CFR 0.152.
 */
package net.smartcosmos.edge.things.resource;

import net.smartcosmos.annotation.SmartCosmosRdao;
import net.smartcosmos.edge.things.service.DeleteThingEdgeService;
import net.smartcosmos.security.user.SmartCosmosUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.request.async.DeferredResult;

@SmartCosmosRdao
@ConditionalOnProperty(prefix="smartcosmos.endpoints.edge.things", name={"enabled"}, matchIfMissing=true)
public class DeleteThingResource {
    private static final Logger log = LoggerFactory.getLogger(DeleteThingResource.class);
    DeleteThingEdgeService deleteThingService;

    @Autowired
    public DeleteThingResource(DeleteThingEdgeService deleteThingService) {
        this.deleteThingService = deleteThingService;
    }

    @ConditionalOnProperty(prefix="smartcosmos.endpoints.edge.things.delete", name={"enabled"}, matchIfMissing=true)
    @RequestMapping(value={"/{type}/{urn}"}, method={RequestMethod.DELETE})
    public DeferredResult<ResponseEntity> delete(@PathVariable(value="type") String type, @PathVariable(value="urn") String urn, SmartCosmosUser user) {
        DeferredResult response = new DeferredResult();
        this.deleteThingService.delete((DeferredResult<ResponseEntity>)response, type, urn, user);
        return response;
    }
}

