/*
 * Decompiled with CFR 0.152.
 */
package net.smartcosmos.edge.things.resource;

import java.util.Set;
import javax.validation.Valid;
import net.smartcosmos.annotation.SmartCosmosRdao;
import net.smartcosmos.edge.things.service.GetThingEdgeService;
import net.smartcosmos.security.user.SmartCosmosUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@SmartCosmosRdao
@ConditionalOnProperty(prefix="smartcosmos.endpoints.edge.things", name={"enabled"}, matchIfMissing=true)
public class GetThingResource {
    private static final Logger log = LoggerFactory.getLogger(GetThingResource.class);
    GetThingEdgeService getThingService;

    @Autowired
    public GetThingResource(GetThingEdgeService getThingService) {
        this.getThingService = getThingService;
    }

    @ConditionalOnProperty(prefix="smartcosmos.endpoints.edge.things.read.urn", name={"enabled"}, matchIfMissing=true)
    @RequestMapping(value={"/{type}/{urn}"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"}, consumes={"application/json;charset=UTF-8"})
    public ResponseEntity<?> findSpecific(@PathVariable(value="type") String type, @PathVariable(value="urn") String urn, @RequestParam(name="fields", required=false) Set<String> fields, SmartCosmosUser user) {
        return this.getThingService.getByTypeAndUrn(type, urn, fields, user);
    }

    @ConditionalOnProperty(prefix="smartcosmos.endpoints.edge.things.read.type", name={"enabled"}, matchIfMissing=true)
    @RequestMapping(value={"/{type}"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"}, consumes={"application/json;charset=UTF-8"})
    public ResponseEntity<?> findByType(@PathVariable(value="type") String type, @RequestParam(name="fields", required=false) Set<String> fields, @RequestParam(name="page", required=false, defaultValue="1") Integer page, @RequestParam(name="size", required=false, defaultValue="20") Integer size, @Valid @RequestParam(name="sortOrder", required=false, defaultValue="asc") String sortOrder, @RequestParam(name="sortBy", required=false, defaultValue="created") String sortBy, SmartCosmosUser user) {
        return this.getThingService.getByType(type, fields, page, size, sortOrder, sortBy, user);
    }
}

