/*
 * Decompiled with CFR 0.152.
 */
package net.smartcosmos.edge.things.rest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class RestTemplateFactory {
    private static final Logger log = LoggerFactory.getLogger(RestTemplateFactory.class);
    private final OAuth2RestTemplate oAuth2RestTemplate;

    @Autowired
    public RestTemplateFactory(@Qualifier(value="userRestTemplate") OAuth2RestTemplate oAuth2RestTemplate) {
        this.oAuth2RestTemplate = oAuth2RestTemplate;
    }

    public RestTemplate getRestTemplate() {
        this.oAuth2RestTemplate.getOAuth2ClientContext().setAccessToken(this.getOAuth2TokenFromAuthentication());
        return this.oAuth2RestTemplate;
    }

    protected OAuth2AccessToken getOAuth2TokenFromAuthentication() {
        return new DefaultOAuth2AccessToken(((OAuth2AuthenticationDetails)SecurityContextHolder.getContext().getAuthentication().getDetails()).getTokenValue());
    }
}

