/*
 * Decompiled with CFR 0.152.
 */
package net.smartcosmos.edge.things.rest.request;

import java.util.Map;
import java.util.Set;
import net.smartcosmos.edge.things.config.SmartCosmosEdgeThingsProperties;
import net.smartcosmos.edge.things.rest.request.SmartCosmosRequest;
import net.smartcosmos.edge.things.util.UrlEncodingUtil;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class MetadataRequestFactory {
    private final String serviceName;

    @Autowired
    public MetadataRequestFactory(SmartCosmosEdgeThingsProperties edgeThingsProperties) {
        this.serviceName = edgeThingsProperties.getLocal().getMetadata();
    }

    public RequestEntity<Map<String, Object>> createOrUpsertRequest(String ownerType, String ownerUrn, Boolean force, Map<String, Object> keyValuePairs) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((String)ownerType), (String)"owner type may not be empty");
        Assert.isTrue((boolean)StringUtils.isNotBlank((String)ownerUrn), (String)"owner URN may not be empty");
        String url = UriComponentsBuilder.fromPath((String)UrlEncodingUtil.encode(ownerType)).pathSegment(new String[]{UrlEncodingUtil.encode(ownerUrn)}).queryParam("force", new Object[]{BooleanUtils.isTrue((Boolean)force) ? String.valueOf(force) : ""}).build().toUriString();
        return SmartCosmosRequest.builder().serviceName(this.serviceName).httpMethod(HttpMethod.POST).url(url).requestBody(keyValuePairs).build().buildRequest();
    }

    public RequestEntity<Void> findByOwnerRequest(String ownerType, String ownerUrn, Set<String> keyNames) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((String)ownerType), (String)"owner type may not be empty");
        Assert.isTrue((boolean)StringUtils.isNotBlank((String)ownerUrn), (String)"owner URN may not be empty");
        String url = UriComponentsBuilder.fromPath((String)UrlEncodingUtil.encode(ownerType)).pathSegment(new String[]{UrlEncodingUtil.encode(ownerUrn)}).queryParam("keys", new Object[]{keyNames != null && !keyNames.isEmpty() ? StringUtils.join(keyNames, (char)',') : ""}).build().toUriString();
        return SmartCosmosRequest.builder().serviceName(this.serviceName).httpMethod(HttpMethod.GET).url(url).build().buildRequest();
    }

    public RequestEntity<?> deleteAllForOwnerRequest(String ownerType, String ownerUrn) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((String)ownerType), (String)"owner type may not be empty");
        Assert.isTrue((boolean)StringUtils.isNotBlank((String)ownerUrn), (String)"owner URN may not be empty");
        String url = UriComponentsBuilder.fromPath((String)UrlEncodingUtil.encode(ownerType)).pathSegment(new String[]{UrlEncodingUtil.encode(ownerUrn)}).build().toUriString();
        return SmartCosmosRequest.builder().serviceName(this.serviceName).httpMethod(HttpMethod.DELETE).url(url).build().buildRequest();
    }
}

