/*
 * Decompiled with CFR 0.152.
 */
package net.smartcosmos.edge.things.rest.request;

import java.beans.ConstructorProperties;
import java.net.URI;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.util.MultiValueMap;

public class SmartCosmosRequest<T> {
    private String serviceName;
    private String url;
    private T requestBody;
    private HttpMethod httpMethod;

    @ConstructorProperties(value={"serviceName", "url", "requestBody", "httpMethod"})
    SmartCosmosRequest(String serviceName, String url, T requestBody, HttpMethod httpMethod) {
        this.serviceName = serviceName;
        this.url = url;
        this.requestBody = requestBody;
        this.httpMethod = httpMethod;
    }

    public static SmartCosmosRequestBuilder builder() {
        return new SmartCosmosRequestBuilder();
    }

    public RequestEntity<T> buildRequest() {
        if (this.url.startsWith("/")) {
            this.url = this.url.substring(1);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        URI uri = URI.create(this.serviceName + "/" + this.url);
        return new RequestEntity(this.requestBody, (MultiValueMap)headers, this.httpMethod, uri);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getUrl() {
        return this.url;
    }

    public T getRequestBody() {
        return this.requestBody;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setRequestBody(T requestBody) {
        this.requestBody = requestBody;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmartCosmosRequest)) {
            return false;
        }
        SmartCosmosRequest other = (SmartCosmosRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        T this$requestBody = this.getRequestBody();
        T other$requestBody = other.getRequestBody();
        if (this$requestBody == null ? other$requestBody != null : !this$requestBody.equals(other$requestBody)) {
            return false;
        }
        HttpMethod this$httpMethod = this.getHttpMethod();
        HttpMethod other$httpMethod = other.getHttpMethod();
        return !(this$httpMethod == null ? other$httpMethod != null : !this$httpMethod.equals(other$httpMethod));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SmartCosmosRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        T $requestBody = this.getRequestBody();
        result = result * 59 + ($requestBody == null ? 43 : $requestBody.hashCode());
        HttpMethod $httpMethod = this.getHttpMethod();
        result = result * 59 + ($httpMethod == null ? 43 : $httpMethod.hashCode());
        return result;
    }

    public String toString() {
        return "SmartCosmosRequest(serviceName=" + this.getServiceName() + ", url=" + this.getUrl() + ", requestBody=" + this.getRequestBody() + ", httpMethod=" + this.getHttpMethod() + ")";
    }

    public static class SmartCosmosRequestBuilder<T> {
        private String serviceName;
        private String url;
        private T requestBody;
        private HttpMethod httpMethod;

        SmartCosmosRequestBuilder() {
        }

        public SmartCosmosRequestBuilder<T> serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public SmartCosmosRequestBuilder<T> url(String url) {
            this.url = url;
            return this;
        }

        public SmartCosmosRequestBuilder<T> requestBody(T requestBody) {
            this.requestBody = requestBody;
            return this;
        }

        public SmartCosmosRequestBuilder<T> httpMethod(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public SmartCosmosRequest<T> build() {
            return new SmartCosmosRequest<T>(this.serviceName, this.url, this.requestBody, this.httpMethod);
        }

        public String toString() {
            return "net.smartcosmos.edge.things.rest.request.SmartCosmosRequest.SmartCosmosRequestBuilder(serviceName=" + this.serviceName + ", url=" + this.url + ", requestBody=" + this.requestBody + ", httpMethod=" + this.httpMethod + ")";
        }
    }
}

