/*
 * Decompiled with CFR 0.152.
 */
package net.smartcosmos.edge.things.rest.request;

import net.smartcosmos.edge.things.config.SmartCosmosEdgeThingsProperties;
import net.smartcosmos.edge.things.domain.things.RestThingCreate;
import net.smartcosmos.edge.things.domain.things.RestThingUpdate;
import net.smartcosmos.edge.things.rest.request.SmartCosmosRequest;
import net.smartcosmos.edge.things.util.UrlEncodingUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class ThingRequestFactory {
    private final String serviceName;

    @Autowired
    public ThingRequestFactory(SmartCosmosEdgeThingsProperties edgeThingsProperties) {
        this.serviceName = edgeThingsProperties.getLocal().getThings();
    }

    public RequestEntity<RestThingCreate> createRequest(String type, RestThingCreate body) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((String)type), (String)"type may not be empty");
        String url = UriComponentsBuilder.fromPath((String)UrlEncodingUtil.encode(type)).build().toUriString();
        return SmartCosmosRequest.builder().serviceName(this.serviceName).httpMethod(HttpMethod.POST).url(url).requestBody(body).build().buildRequest();
    }

    public RequestEntity<Void> findByTypeRequest(String type, Integer page, Integer size) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((String)type), (String)"type may not be empty");
        String url = UriComponentsBuilder.fromPath((String)UrlEncodingUtil.encode(type)).queryParam("page", new Object[]{page != null ? page : ""}).queryParam("size", new Object[]{size != null ? size : ""}).build().toUriString();
        return SmartCosmosRequest.builder().serviceName(this.serviceName).httpMethod(HttpMethod.GET).url(url).build().buildRequest();
    }

    public RequestEntity<Void> findSpecificRequest(String type, String urn) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((String)type), (String)"type may not be empty");
        Assert.isTrue((boolean)StringUtils.isNotBlank((String)urn), (String)"URN may not be empty");
        String url = UriComponentsBuilder.fromPath((String)UrlEncodingUtil.encode(type)).pathSegment(new String[]{UrlEncodingUtil.encode(urn)}).build().toUriString();
        return SmartCosmosRequest.builder().serviceName(this.serviceName).httpMethod(HttpMethod.GET).url(url).build().buildRequest();
    }

    public RequestEntity<RestThingUpdate> updateRequest(String type, String urn, RestThingUpdate body) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((String)type), (String)"type may not be empty");
        Assert.isTrue((boolean)StringUtils.isNotBlank((String)urn), (String)"URN may not be empty");
        String url = UriComponentsBuilder.fromPath((String)UrlEncodingUtil.encode(type)).pathSegment(new String[]{UrlEncodingUtil.encode(urn)}).build().toUriString();
        return SmartCosmosRequest.builder().serviceName(this.serviceName).httpMethod(HttpMethod.PUT).url(url).requestBody(body).build().buildRequest();
    }

    public RequestEntity<?> deleteRequest(String type, String urn) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((String)type), (String)"type may not be empty");
        Assert.isTrue((boolean)StringUtils.isNotBlank((String)urn), (String)"URN may not be empty");
        String url = UriComponentsBuilder.fromPath((String)UrlEncodingUtil.encode(type)).pathSegment(new String[]{UrlEncodingUtil.encode(urn)}).build().toUriString();
        return SmartCosmosRequest.builder().serviceName(this.serviceName).httpMethod(HttpMethod.DELETE).url(url).build().buildRequest();
    }
}

