/*
 * Decompiled with CFR 0.152.
 */
package net.smartcosmos.edge.things.service;

import java.util.Map;
import net.smartcosmos.edge.things.domain.RestThingMetadataCreateContainer;
import net.smartcosmos.edge.things.domain.things.RestThingCreateResponseDto;
import net.smartcosmos.edge.things.service.CreateThingEdgeService;
import net.smartcosmos.edge.things.service.metadata.CreateMetadataRestService;
import net.smartcosmos.edge.things.service.things.CreateThingRestService;
import net.smartcosmos.edge.things.util.ResponseBuilderUtility;
import net.smartcosmos.security.user.SmartCosmosUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConversionService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.async.DeferredResult;

@Service
public class CreateThingEdgeServiceDefault
implements CreateThingEdgeService {
    private static final Logger log = LoggerFactory.getLogger(CreateThingEdgeServiceDefault.class);
    private final ConversionService conversionService;
    private final CreateMetadataRestService createMetadataService;
    private final CreateThingRestService createThingService;

    @Autowired
    public CreateThingEdgeServiceDefault(ConversionService conversionService, CreateMetadataRestService createMetadataService, CreateThingRestService createThingService) {
        this.conversionService = conversionService;
        this.createMetadataService = createMetadataService;
        this.createThingService = createThingService;
    }

    @Override
    public void create(DeferredResult<ResponseEntity> response, String type, Map<String, Object> metadataMap, Boolean force, SmartCosmosUser user) {
        try {
            response.setResult(this.createWorker(type, metadataMap, force, user));
        }
        catch (Exception e) {
            String msg = this.createByTypeLogMessage(type, user, e.toString(), force, metadataMap.toString());
            log.error(msg);
            log.debug(msg, (Throwable)e);
            response.setErrorResult((Object)e);
        }
    }

    protected ResponseEntity<?> createWorker(String type, Map<String, Object> metadataMap, Boolean force, SmartCosmosUser user) {
        RestThingCreateResponseDto thingResponseBody;
        String urn;
        ResponseEntity<?> metadataResponse;
        RestThingMetadataCreateContainer container = (RestThingMetadataCreateContainer)this.conversionService.convert(metadataMap, RestThingMetadataCreateContainer.class);
        ResponseEntity<?> thingResponse = this.createThingService.create(type, container.getThingRequestBody(), user);
        Map<String, Object> reducedMetadataMap = container.getMetadataRequestBody();
        if (!CreateThingEdgeServiceDefault.successfullyCreatedThing(thingResponse, force)) {
            log.warn(this.createByTypeLogMessage(type, user, "create core thing = " + thingResponse.toString(), force, metadataMap.toString()));
            return ResponseBuilderUtility.buildForwardingResponse(thingResponse);
        }
        if (CreateThingEdgeServiceDefault.hasMetadataToCreate(reducedMetadataMap) && !CreateThingEdgeServiceDefault.successfullyCreatedMetadata(metadataResponse = this.createMetadataService.create(type, urn = (thingResponseBody = (RestThingCreateResponseDto)thingResponse.getBody()).getUrn(), force, reducedMetadataMap, user))) {
            log.warn(this.createByTypeLogMessage(type, user, "create core metadata = " + metadataResponse.toString(), force, metadataMap.toString()));
            return ResponseBuilderUtility.buildForwardingResponse(metadataResponse);
        }
        return ResponseBuilderUtility.buildForwardingResponse(thingResponse);
    }

    private String createByTypeLogMessage(String type, SmartCosmosUser user, String message, Boolean force, String requestBody) {
        return String.format("Create request for Thing with type '%s' by user '%s' failed: %s\nRequest: (force = %s): %s", type, user, message, force.toString(), requestBody);
    }

    protected static boolean hasMetadataToCreate(Map<String, Object> metadataMap) {
        return !metadataMap.isEmpty();
    }

    protected static boolean successfullyCreatedThing(ResponseEntity thingResponse, Boolean force) {
        HttpStatus status = thingResponse.getStatusCode();
        return (status.is2xxSuccessful() || force != false && HttpStatus.CONFLICT.equals((Object)status)) && thingResponse.hasBody() && thingResponse.getBody() instanceof RestThingCreateResponseDto;
    }

    protected static boolean successfullyCreatedMetadata(ResponseEntity metadataResponse) {
        return metadataResponse.getStatusCode().is2xxSuccessful();
    }
}

