/*
 * Decompiled with CFR 0.152.
 */
package net.smartcosmos.edge.things.service;

import net.smartcosmos.edge.things.service.DeleteThingEdgeService;
import net.smartcosmos.edge.things.service.metadata.DeleteMetadataRestService;
import net.smartcosmos.edge.things.service.things.DeleteThingRestService;
import net.smartcosmos.edge.things.util.ResponseBuilderUtility;
import net.smartcosmos.security.user.SmartCosmosUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.async.DeferredResult;

@Service
public class DeleteThingEdgeServiceDefault
implements DeleteThingEdgeService {
    private static final Logger log = LoggerFactory.getLogger(DeleteThingEdgeServiceDefault.class);
    private final DeleteMetadataRestService deleteMetadataService;
    private final DeleteThingRestService deleteThingService;

    @Autowired
    public DeleteThingEdgeServiceDefault(DeleteMetadataRestService deleteMetadataService, DeleteThingRestService deleteThingService) {
        this.deleteMetadataService = deleteMetadataService;
        this.deleteThingService = deleteThingService;
    }

    @Override
    public void delete(DeferredResult<ResponseEntity> response, String type, String urn, SmartCosmosUser user) {
        try {
            response.setResult(this.deleteWorker(type, urn, user));
        }
        catch (Exception e) {
            String msg = this.deleteByTypeAndUrnLogMessage(type, urn, user, e.toString());
            log.error(msg);
            log.debug(msg, (Throwable)e);
            response.setErrorResult((Object)e);
        }
    }

    protected ResponseEntity<?> deleteWorker(String type, String urn, SmartCosmosUser user) {
        ResponseEntity<?> thingResponse = this.deleteThingService.delete(type, urn, user);
        if (thingResponse.getStatusCode().is2xxSuccessful()) {
            ResponseEntity<?> metadataResponse = this.deleteMetadataService.delete(type, urn, user);
            if (!metadataResponse.getStatusCode().is2xxSuccessful() && HttpStatus.NOT_FOUND != metadataResponse.getStatusCode()) {
                return ResponseBuilderUtility.buildForwardingResponse(metadataResponse);
            }
        } else {
            log.warn(this.deleteByTypeAndUrnLogMessage(type, urn, user, thingResponse.toString()));
        }
        return ResponseBuilderUtility.buildForwardingResponse(thingResponse);
    }

    private String deleteByTypeAndUrnLogMessage(String type, String urn, SmartCosmosUser user, String message) {
        return String.format("Delete request for Thing with type '%s' and urn '%s' by user '%s' failed: %s", type, urn, user, message);
    }
}

