/*
 * Decompiled with CFR 0.152.
 */
package net.smartcosmos.edge.things.service;

import java.util.Map;
import net.smartcosmos.edge.things.domain.RestThingMetadataUpdateContainer;
import net.smartcosmos.edge.things.domain.things.RestThingUpdate;
import net.smartcosmos.edge.things.service.UpdateThingEdgeService;
import net.smartcosmos.edge.things.service.metadata.UpsertMetadataRestService;
import net.smartcosmos.edge.things.service.things.UpdateThingRestService;
import net.smartcosmos.edge.things.util.ResponseBuilderUtility;
import net.smartcosmos.security.user.SmartCosmosUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConversionService;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.async.DeferredResult;

@Service
public class UpdateThingEdgeServiceDefault
implements UpdateThingEdgeService {
    private static final Logger log = LoggerFactory.getLogger(UpdateThingEdgeServiceDefault.class);
    private final ConversionService conversionService;
    private final UpsertMetadataRestService upsertMetadataService;
    private final UpdateThingRestService updateThingService;

    @Autowired
    public UpdateThingEdgeServiceDefault(ConversionService conversionService, UpsertMetadataRestService upsertMetadataService, UpdateThingRestService updateThingService) {
        this.conversionService = conversionService;
        this.upsertMetadataService = upsertMetadataService;
        this.updateThingService = updateThingService;
    }

    @Override
    public void update(DeferredResult<ResponseEntity> response, String type, String urn, Map<String, Object> requestBody, SmartCosmosUser user) {
        try {
            response.setResult(this.updateWorker(type, urn, requestBody, user));
        }
        catch (Exception e) {
            String msg = this.updateByTypeAndUrnLogMessage(type, urn, user, e.toString(), requestBody.toString());
            log.error(msg);
            log.debug(msg, (Throwable)e);
            response.setErrorResult((Object)e);
        }
    }

    protected ResponseEntity<?> updateWorker(String type, String urn, Map<String, Object> requestBody, SmartCosmosUser user) {
        ResponseEntity<?> metadataResponse;
        ResponseEntity<?> thingResponse;
        RestThingMetadataUpdateContainer container = (RestThingMetadataUpdateContainer)this.conversionService.convert(requestBody, RestThingMetadataUpdateContainer.class);
        Map<String, Object> reducedMetadataMap = container.getMetadataRequestBody();
        RestThingUpdate thingUpdate = container.getThingRequestBody();
        if (thingUpdate == null && reducedMetadataMap.isEmpty()) {
            log.warn(this.updateByTypeAndUrnLogMessage(type, urn, user, "Nothing to update", requestBody.toString()));
            return ResponseBuilderUtility.buildBadRequestResponse(1, "Nothing to update");
        }
        if (thingUpdate != null && !(thingResponse = this.updateThingService.update(type, urn, thingUpdate, user)).getStatusCode().is2xxSuccessful()) {
            log.warn(this.updateByTypeAndUrnLogMessage(type, urn, user, "update core thing = " + thingResponse.toString(), requestBody.toString()));
            return ResponseBuilderUtility.buildForwardingResponse(thingResponse);
        }
        if (!reducedMetadataMap.isEmpty() && !(metadataResponse = this.upsertMetadataService.upsert(type, urn, reducedMetadataMap, user)).getStatusCode().is2xxSuccessful()) {
            log.warn(this.updateByTypeAndUrnLogMessage(type, urn, user, "update core metadata = " + metadataResponse.toString(), requestBody.toString()));
            return ResponseBuilderUtility.buildForwardingResponse(metadataResponse);
        }
        return ResponseEntity.noContent().build();
    }

    private String updateByTypeAndUrnLogMessage(String type, String urn, SmartCosmosUser user, String message, String requestBody) {
        return String.format("Update request for Thing with type '%s' and urn '%s' by user '%s' failed: %s\nRequest: %s", type, urn, user, message, requestBody);
    }
}

