/*
 * Decompiled with CFR 0.152.
 */
package net.smartcosmos.edge.things.service.event;

import net.smartcosmos.edge.things.service.event.EventSendingService;
import net.smartcosmos.edge.things.util.ThingEdgeEventType;
import net.smartcosmos.events.SmartCosmosEventException;
import net.smartcosmos.events.SmartCosmosEventTemplate;
import net.smartcosmos.security.user.SmartCosmosUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ThingEdgeEventSendingService
implements EventSendingService {
    private static final Logger log = LoggerFactory.getLogger(ThingEdgeEventSendingService.class);
    private final SmartCosmosEventTemplate smartCosmosEventTemplate;

    @Autowired
    public ThingEdgeEventSendingService(SmartCosmosEventTemplate smartCosmosEventTemplate) {
        this.smartCosmosEventTemplate = smartCosmosEventTemplate;
    }

    public void sendEvent(SmartCosmosUser user, ThingEdgeEventType eventType, Object entity) {
        this.sendEvent(user, eventType.getEventName(), entity);
    }

    public void sendEvent(SmartCosmosUser user, String eventType, Object entity) {
        try {
            this.smartCosmosEventTemplate.sendEvent(entity, eventType, user);
        }
        catch (SmartCosmosEventException e) {
            String msg = String.format("Exception processing metadata event '%s', entity: '%s', cause: '%s'.", eventType, entity, e.toString());
            log.error(msg);
            log.debug(msg, (Throwable)e);
        }
    }
}

