/*
 * Decompiled with CFR 0.152.
 */
package net.smartcosmos.edge.things.service.metadata;

import java.util.Map;
import net.smartcosmos.edge.things.domain.metadata.RestMetadataCreateResponseDto;
import net.smartcosmos.edge.things.rest.RestTemplateFactory;
import net.smartcosmos.edge.things.rest.request.MetadataRequestFactory;
import net.smartcosmos.edge.things.service.metadata.CreateMetadataRestService;
import net.smartcosmos.security.user.SmartCosmosUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class CreateMetadataRestServiceDefault
implements CreateMetadataRestService {
    private static final Logger log = LoggerFactory.getLogger(CreateMetadataRestServiceDefault.class);
    private final RestTemplateFactory restTemplateFactory;
    private final MetadataRequestFactory requestFactory;

    @Autowired
    public CreateMetadataRestServiceDefault(RestTemplateFactory restTemplateFactory, MetadataRequestFactory requestFactory) {
        this.restTemplateFactory = restTemplateFactory;
        this.requestFactory = requestFactory;
    }

    @Override
    public ResponseEntity<?> create(String ownerType, String ownerUrn, Boolean force, Map<String, Object> metadataMap, SmartCosmosUser user) {
        RequestEntity<Map<String, Object>> requestEntity = this.requestFactory.createOrUpsertRequest(ownerType, ownerUrn, force, metadataMap);
        return this.restTemplateFactory.getRestTemplate().exchange(requestEntity, RestMetadataCreateResponseDto.class);
    }
}

