/*
 * Decompiled with CFR 0.152.
 */
package net.smartcosmos.edge.things.service.metadata;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.smartcosmos.edge.things.rest.RestTemplateFactory;
import net.smartcosmos.edge.things.rest.request.MetadataRequestFactory;
import net.smartcosmos.edge.things.service.metadata.GetMetadataRestService;
import net.smartcosmos.security.user.SmartCosmosUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class GetMetadataRestServiceDefault
implements GetMetadataRestService {
    private static final Logger log = LoggerFactory.getLogger(GetMetadataRestServiceDefault.class);
    private final RestTemplateFactory restTemplateFactory;
    private final MetadataRequestFactory requestFactory;

    @Autowired
    public GetMetadataRestServiceDefault(RestTemplateFactory restTemplateFactory, MetadataRequestFactory requestFactory) {
        this.restTemplateFactory = restTemplateFactory;
        this.requestFactory = requestFactory;
    }

    @Override
    public ResponseEntity<?> findByOwner(String ownerType, String ownerUrn, Set<String> keyNames, SmartCosmosUser user) {
        RequestEntity<Void> requestEntity = this.requestFactory.findByOwnerRequest(ownerType, ownerUrn, keyNames);
        return this.restTemplateFactory.getRestTemplate().exchange(requestEntity, Map.class);
    }

    @Override
    public ResponseEntity<?> findByOwner(String ownerType, String ownerUrn, SmartCosmosUser user) {
        return this.findByOwner(ownerType, ownerUrn, new HashSet<String>(), user);
    }
}

