/*
 * Decompiled with CFR 0.152.
 */
package net.smartcosmos.edge.things.service.metadata;

import java.util.Map;
import net.smartcosmos.edge.things.domain.metadata.RestMetadataCreateResponseDto;
import net.smartcosmos.edge.things.rest.RestTemplateFactory;
import net.smartcosmos.edge.things.rest.request.MetadataRequestFactory;
import net.smartcosmos.edge.things.service.metadata.UpsertMetadataRestService;
import net.smartcosmos.security.user.SmartCosmosUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class UpsertMetadataRestServiceDefault
implements UpsertMetadataRestService {
    private static final Logger log = LoggerFactory.getLogger(UpsertMetadataRestServiceDefault.class);
    private final RestTemplateFactory restTemplateFactory;
    private final MetadataRequestFactory requestFactory;

    @Autowired
    public UpsertMetadataRestServiceDefault(RestTemplateFactory restTemplateFactory, MetadataRequestFactory requestFactory) {
        this.restTemplateFactory = restTemplateFactory;
        this.requestFactory = requestFactory;
    }

    @Override
    public ResponseEntity<?> upsert(String ownerType, String ownerUrn, Map<String, Object> metadataMap, SmartCosmosUser user) {
        RequestEntity<Map<String, Object>> requestEntity = this.requestFactory.createOrUpsertRequest(ownerType, ownerUrn, true, metadataMap);
        return this.restTemplateFactory.getRestTemplate().exchange(requestEntity, RestMetadataCreateResponseDto.class);
    }
}

