/*
 * Decompiled with CFR 0.152.
 */
package net.smartcosmos.edge.things.service.things;

import net.smartcosmos.edge.things.domain.things.RestThingCreate;
import net.smartcosmos.edge.things.domain.things.RestThingCreateResponseDto;
import net.smartcosmos.edge.things.rest.RestTemplateFactory;
import net.smartcosmos.edge.things.rest.request.ThingRequestFactory;
import net.smartcosmos.edge.things.service.things.CreateThingRestService;
import net.smartcosmos.security.user.SmartCosmosUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class CreateThingRestServiceDefault
implements CreateThingRestService {
    private static final Logger log = LoggerFactory.getLogger(CreateThingRestServiceDefault.class);
    private final RestTemplateFactory restTemplateFactory;
    private final ThingRequestFactory requestFactory;

    @Autowired
    public CreateThingRestServiceDefault(RestTemplateFactory restTemplateFactory, ThingRequestFactory requestFactory) {
        this.restTemplateFactory = restTemplateFactory;
        this.requestFactory = requestFactory;
    }

    @Override
    public ResponseEntity<?> create(String type, RestThingCreate thingCreate, SmartCosmosUser user) {
        RequestEntity<RestThingCreate> requestEntity = this.requestFactory.createRequest(type, thingCreate);
        return this.restTemplateFactory.getRestTemplate().exchange(requestEntity, RestThingCreateResponseDto.class);
    }

    @Override
    public ResponseEntity<?> create(String type, SmartCosmosUser user) {
        return this.create(type, new RestThingCreate(), user);
    }
}

