/*
 * Decompiled with CFR 0.152.
 */
package net.smartcosmos.edge.things.service.things;

import net.smartcosmos.edge.things.domain.things.RestPagedThingResponse;
import net.smartcosmos.edge.things.domain.things.RestThingResponse;
import net.smartcosmos.edge.things.rest.RestTemplateFactory;
import net.smartcosmos.edge.things.rest.request.ThingRequestFactory;
import net.smartcosmos.edge.things.service.things.GetThingRestService;
import net.smartcosmos.security.user.SmartCosmosUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class GetThingRestServiceDefault
implements GetThingRestService {
    private static final Logger log = LoggerFactory.getLogger(GetThingRestServiceDefault.class);
    private final RestTemplateFactory restTemplateFactory;
    private final ThingRequestFactory requestFactory;

    @Autowired
    public GetThingRestServiceDefault(RestTemplateFactory restTemplateFactory, ThingRequestFactory requestFactory) {
        this.restTemplateFactory = restTemplateFactory;
        this.requestFactory = requestFactory;
    }

    @Override
    public ResponseEntity<?> findByTypeAndUrn(String type, String urn, SmartCosmosUser user) {
        RequestEntity<Void> requestEntity = this.requestFactory.findSpecificRequest(type, urn);
        return this.restTemplateFactory.getRestTemplate().exchange(requestEntity, RestThingResponse.class);
    }

    @Override
    public ResponseEntity findByType(String type, Integer page, Integer size, String sortOrder, String sortBy, SmartCosmosUser user) {
        RequestEntity<Void> requestEntity = this.requestFactory.findByTypeRequest(type, page, size);
        return this.restTemplateFactory.getRestTemplate().exchange(requestEntity, RestPagedThingResponse.class);
    }
}

