/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import net.wimpi.pim.contact.io.vcard.ADRItemHandler;
import net.wimpi.pim.contact.io.vcard.BDAYItemHandler;
import net.wimpi.pim.contact.io.vcard.CATEGORIESItemHandler;
import net.wimpi.pim.contact.io.vcard.CLASSItemHandler;
import net.wimpi.pim.contact.io.vcard.EMAILItemHandler;
import net.wimpi.pim.contact.io.vcard.FNItemHandler;
import net.wimpi.pim.contact.io.vcard.GEOItemHandler;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.io.vcard.KEYItemHandler;
import net.wimpi.pim.contact.io.vcard.LABELItemHandler;
import net.wimpi.pim.contact.io.vcard.LOGOItemHandler;
import net.wimpi.pim.contact.io.vcard.MAILERItemHandler;
import net.wimpi.pim.contact.io.vcard.NICKNAMEItemHandler;
import net.wimpi.pim.contact.io.vcard.NItemHandler;
import net.wimpi.pim.contact.io.vcard.NOTEItemHandler;
import net.wimpi.pim.contact.io.vcard.ORGItemHandler;
import net.wimpi.pim.contact.io.vcard.PHOTOItemHandler;
import net.wimpi.pim.contact.io.vcard.REVItemHandler;
import net.wimpi.pim.contact.io.vcard.ROLEItemHandler;
import net.wimpi.pim.contact.io.vcard.SORTSTRINGItemHandler;
import net.wimpi.pim.contact.io.vcard.SOUNDItemHandler;
import net.wimpi.pim.contact.io.vcard.TELItemHandler;
import net.wimpi.pim.contact.io.vcard.TITLEItemHandler;
import net.wimpi.pim.contact.io.vcard.TZItemHandler;
import net.wimpi.pim.contact.io.vcard.URLItemHandler;
import net.wimpi.pim.contact.io.vcard.XORGURLItemHandler;
import net.wimpi.pim.util.versitio.versitException;

public class ItemHandlerManager {
    private static ItemHandlerManager c_Self;
    private HashMap m_Handlers;
    private Set m_Extensions;

    private ItemHandlerManager() {
        c_Self = this;
        this.prepareHandlers();
        this.prepareExtensions();
    }

    public ItemHandler getItemHandler(String identifier) {
        return (ItemHandler)this.m_Handlers.get(identifier);
    }

    private void addItemHandler(String identifier, ItemHandler handler) {
        this.m_Handlers.put(identifier, handler);
    }

    public boolean hasHandler(String identifier) {
        return this.m_Handlers.containsKey(identifier);
    }

    public String[] listExtensions() {
        String[] xtnd = new String[this.m_Extensions.size()];
        return this.m_Extensions.toArray(xtnd);
    }

    public void addExtensionHandler(String xidentifier, ItemHandler handler) throws versitException {
        if (this.m_Extensions.contains(xidentifier)) {
            throw new versitException("Extension tokens have to be unique.");
        }
        this.m_Extensions.add(xidentifier);
        this.addItemHandler(xidentifier, handler);
    }

    private void prepareHandlers() {
        this.m_Handlers = new HashMap(35);
        this.m_Handlers.put("N", new NItemHandler());
        this.m_Handlers.put("FN", new FNItemHandler());
        this.m_Handlers.put("NICKNAME", new NICKNAMEItemHandler());
        this.m_Handlers.put("PHOTO", new PHOTOItemHandler());
        this.m_Handlers.put("BDAY", new BDAYItemHandler());
        this.m_Handlers.put("ADR", new ADRItemHandler());
        this.m_Handlers.put("LABEL", new LABELItemHandler());
        this.m_Handlers.put("TEL", new TELItemHandler());
        this.m_Handlers.put("EMAIL", new EMAILItemHandler());
        this.m_Handlers.put("MAILER", new MAILERItemHandler());
        this.m_Handlers.put("TZ", new TZItemHandler());
        this.m_Handlers.put("GEO", new GEOItemHandler());
        this.m_Handlers.put("TITLE", new TITLEItemHandler());
        this.m_Handlers.put("ROLE", new ROLEItemHandler());
        this.m_Handlers.put("LOGO", new LOGOItemHandler());
        this.m_Handlers.put("ORG", new ORGItemHandler());
        this.m_Handlers.put("CATEGORIES", new CATEGORIESItemHandler());
        this.m_Handlers.put("NOTE", new NOTEItemHandler());
        this.m_Handlers.put("REV", new REVItemHandler());
        this.m_Handlers.put("SOUND", new SOUNDItemHandler());
        this.m_Handlers.put("SORT-STRING", new SORTSTRINGItemHandler());
        this.m_Handlers.put("KEY", new KEYItemHandler());
        this.m_Handlers.put("URL", new URLItemHandler());
        this.m_Handlers.put("CLASS", new CLASSItemHandler());
    }

    private void prepareExtensions() {
        this.m_Extensions = new TreeSet();
        try {
            this.addExtensionHandler("X-ORG-URL", new XORGURLItemHandler());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ItemHandlerManager getReference() {
        if (c_Self != null) {
            return c_Self;
        }
        return new ItemHandlerManager();
    }
}

