/*
 * Decompiled with CFR 0.152.
 */
package com.particle.gui.router;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import androidx.activity.result.ActivityResultLauncher;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentManager;
import com.particle.base.ParticleNetwork;
import com.particle.gui.router.Interceptor;
import com.particle.gui.router.LoginInterceptor;
import com.particle.gui.router.RouterNavigation;
import com.particle.gui.router.RouterPath;
import com.particle.gui.ui.login.LoginOptFragment;
import com.particle.gui.ui.login.LoginTypeCallBack;
import com.particle.gui.ui.nft_detail.WalletNftDetailActivity;
import com.particle.gui.ui.receive.WalletReceiverActivity;
import com.particle.gui.ui.send.WalletSendActivity;
import com.particle.gui.ui.setting.address_book.AddressBookActivity;
import com.particle.gui.ui.swap.SwapActivity;
import com.particle.gui.ui.token_detail.WalletTokenDetailActivity;
import com.particle.gui.ui.wallet.WalletMainActivity;
import com.particle.gui.utils.Constants;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\tH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0019\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0012\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0016J\u0013\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0000\u00a2\u0006\u0002\b\u0018J\u0016\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u000e2\b\b\u0002\u0010\u001f\u001a\u00020 J\u001e\u0010!\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00052\f\b\u0001\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/particle/gui/router/PNRouter;", "", "()V", "dict", "", "Lcom/particle/gui/router/RouterPath;", "Ljava/lang/Class;", "interceptors", "", "Lcom/particle/gui/router/Interceptor;", "launcherResult", "Landroidx/activity/result/ActivityResultLauncher;", "Landroid/content/Intent;", "addInterceptor", "", "interceptor", "build", "Lcom/particle/gui/router/RouterNavigation;", "path", "params", "Landroid/os/Parcelable;", "getRouterClass", "getRouterClass$gui_release", "getRouterInterceptors", "getRouterInterceptors$gui_release", "navigatorLoginList", "supportFragmentManager", "Landroidx/fragment/app/FragmentManager;", "callback", "Lcom/particle/gui/ui/login/LoginTypeCallBack;", "navigatorSwap", "tokenAddress", "", "register", "cls", "gui_release"})
@Keep
public final class PNRouter {
    @NotNull
    public static final PNRouter INSTANCE = new PNRouter();
    @NotNull
    private static Map<RouterPath, Class<?>> dict = new LinkedHashMap();
    private static ActivityResultLauncher<Intent> launcherResult;
    @NotNull
    private static List<Interceptor> interceptors;

    private PNRouter() {
    }

    private final void register(RouterPath routerPath, @NonNull Class<?> clazz) {
        if (!dict.containsKey((Object)routerPath)) {
            dict.put(routerPath, clazz);
            return;
        }
        throw new IllegalArgumentException("router path can not repeated registration");
    }

    @JvmStatic
    public static final void addInterceptor(@NonNull @NotNull Interceptor object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"interceptor");
        interceptors.add((Interceptor)object);
        object = interceptors;
        if (object.size() > 1) {
            Comparator comparator;
            Object object2 = object;
            object = comparator;
            comparator = new Comparator(){

                public final int compare(T t10, T t11) {
                    return ComparisonsKt.compareValues((Comparable)Integer.valueOf(((Interceptor)t11).priority()), (Comparable)Integer.valueOf(((Interceptor)t10).priority()));
                }
            };
            CollectionsKt.sortWith((List)object2, (Comparator)object);
        }
    }

    @JvmStatic
    @NotNull
    public static final RouterNavigation build(@NotNull RouterPath routerPath) {
        Intrinsics.checkNotNullParameter((Object)((Object)routerPath), (String)"path");
        return new RouterNavigation(routerPath, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final RouterNavigation build(@NotNull RouterPath routerPath, @NotNull Parcelable parcelable) {
        Intrinsics.checkNotNullParameter((Object)((Object)routerPath), (String)"path");
        Intrinsics.checkNotNullParameter((Object)parcelable, (String)"params");
        return new RouterNavigation(routerPath, parcelable);
    }

    public static /* synthetic */ void navigatorSwap$default(PNRouter pNRouter, String string2, int n10, Object object) {
        if ((n10 & 1) != 0) {
            string2 = Constants.INSTANCE.getNATIVE();
        }
        pNRouter.navigatorSwap(string2);
    }

    static {
        interceptors = new ArrayList<Interceptor>();
        PNRouter.addInterceptor(new LoginInterceptor());
        INSTANCE.register(RouterPath.Wallet, WalletMainActivity.class);
        INSTANCE.register(RouterPath.TokenSend, WalletSendActivity.class);
        INSTANCE.register(RouterPath.TokenReceive, WalletReceiverActivity.class);
        INSTANCE.register(RouterPath.TokenTransactionRecords, WalletTokenDetailActivity.class);
        INSTANCE.register(RouterPath.NftDetails, WalletNftDetailActivity.class);
        INSTANCE.register(RouterPath.AddressBook, AddressBookActivity.class);
    }

    @NotNull
    public final Class<?> getRouterClass$gui_release(@NotNull RouterPath routerPath) {
        Intrinsics.checkNotNullParameter((Object)((Object)routerPath), (String)"path");
        if (dict.containsKey((Object)routerPath)) {
            Class<?> clazz = dict.get((Object)routerPath);
            Intrinsics.checkNotNull(clazz);
            return clazz;
        }
        throw new IllegalArgumentException("router path not registered");
    }

    @NotNull
    public final List<Interceptor> getRouterInterceptors$gui_release() {
        return interceptors;
    }

    public final void navigatorLoginList(@NotNull FragmentManager fragmentManager, @NotNull LoginTypeCallBack loginTypeCallBack) {
        Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"supportFragmentManager");
        Intrinsics.checkNotNullParameter((Object)loginTypeCallBack, (String)"callback");
        LoginOptFragment.Companion.show$default(LoginOptFragment.Companion, fragmentManager, false, 2, null).setCallBack(loginTypeCallBack);
    }

    public final void navigatorSwap(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"tokenAddress");
        Context context = ParticleNetwork.INSTANCE.getContext();
        Intent intent = SwapActivity.o.a(ParticleNetwork.INSTANCE.getContext(), string2);
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }
}

