/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.util.resource;

import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.util.resource.Resource;
import org.opensaml.util.resource.ResourceChangeListener;
import org.opensaml.util.resource.ResourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceChangeWatcher
extends TimerTask {
    public static final long DEFAULT_POLL_FREQUENCY = 43200000L;
    public static final int DEFAULT_MAX_RETRY_ATTEMPTS = 0;
    private static Logger log = Logger.getLogger(ResourceChangeWatcher.class);
    private Resource watchedResource;
    private long pollFrequency;
    private int maxRetryAttempts;
    private int currentRetryAttempts;
    private boolean resourceExist;
    private DateTime lastModification;
    private List<ResourceChangeListener> resourceListeners;

    public ResourceChangeWatcher(Resource resource) throws ResourceException {
        this(resource, 43200000L, 0);
    }

    public ResourceChangeWatcher(Resource resource, long pollingFrequency) throws ResourceException {
        this(resource, pollingFrequency, 0);
    }

    public ResourceChangeWatcher(Resource resource, long pollingFrequency, int retryAttempts) throws ResourceException {
        if (resource == null) {
            throw new NullPointerException("Watched resource is null");
        }
        if (pollingFrequency <= 0L) {
            throw new IllegalArgumentException("Polling frequency must be greater than zero");
        }
        if (retryAttempts < 0) {
            throw new IllegalArgumentException("Max retry attempts must be greater than, or equal to, zero");
        }
        this.watchedResource = resource;
        this.pollFrequency = pollingFrequency;
        this.maxRetryAttempts = retryAttempts;
        this.currentRetryAttempts = 0;
        if (this.watchedResource.exists()) {
            this.resourceExist = true;
            this.lastModification = this.watchedResource.getLastModifiedTime();
        } else {
            this.resourceExist = false;
        }
        this.resourceListeners = new ArrayList<ResourceChangeListener>();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Watching resource: " + this.watchedResource.getLocation() + ", polling frequency: " + this.pollFrequency + "ms, max retry attempts: " + this.maxRetryAttempts));
        }
    }

    public long getPollingFrequency() {
        return this.pollFrequency;
    }

    public List<ResourceChangeListener> getResourceListeners() {
        return this.resourceListeners;
    }

    @Override
    public void run() {
        block9: {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Checking resource for changes: " + this.watchedResource.getLocation()));
                }
                if (this.watchedResource.exists()) {
                    if (!this.resourceExist) {
                        this.resourceExist = true;
                        this.signalListeners(ResourceChangeListener.ResourceChange.CREATION);
                        this.lastModification = this.watchedResource.getLastModifiedTime();
                    } else if (this.lastModification.isBefore((ReadableInstant)this.watchedResource.getLastModifiedTime())) {
                        this.signalListeners(ResourceChangeListener.ResourceChange.UPDATE);
                        this.lastModification = this.watchedResource.getLastModifiedTime();
                    }
                } else if (this.resourceExist) {
                    this.resourceExist = false;
                    this.signalListeners(ResourceChangeListener.ResourceChange.DELETE);
                }
                this.currentRetryAttempts = 0;
            }
            catch (ResourceException e) {
                log.warn((Object)("Resource " + this.watchedResource.getLocation() + " could not be accessed"), (Throwable)e);
                ++this.currentRetryAttempts;
                if (this.currentRetryAttempts < this.maxRetryAttempts) break block9;
                this.cancel();
                log.error((Object)("Resource " + this.watchedResource.getLocation() + " was not accessible for max number of retry attempts.  This resource will no longer be watched"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void signalListeners(ResourceChangeListener.ResourceChange changeType) {
        List<ResourceChangeListener> list = this.resourceListeners;
        synchronized (list) {
            switch (changeType) {
                case CREATION: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Publishing creation event for resource: " + this.watchedResource.getLocation()));
                    }
                    for (ResourceChangeListener listener : this.resourceListeners) {
                        listener.onResourceCreate(this.watchedResource);
                    }
                    break;
                }
                case UPDATE: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Publishing update event for resource: " + this.watchedResource.getLocation()));
                    }
                    for (ResourceChangeListener listener : this.resourceListeners) {
                        listener.onResourceUpdate(this.watchedResource);
                    }
                    break;
                }
                case DELETE: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Publishing delete event for resource: " + this.watchedResource.getLocation()));
                    }
                    for (ResourceChangeListener listener : this.resourceListeners) {
                        listener.onResourceDelete(this.watchedResource);
                    }
                    break;
                }
            }
        }
    }
}

